/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.List;

public class TransformOrderByDistinctApplication
extends TransformCopy {
    @Override
    public Op transform(OpDistinct opDistinct, Op subOp) {
        OpProject project;
        if (subOp instanceof OpProject && (project = (OpProject)subOp).getSubOp() instanceof OpOrder) {
            List<Var> projectVars = project.getVars();
            OpOrder order = (OpOrder)project.getSubOp();
            boolean ok = true;
            for (SortCondition condition : order.getConditions()) {
                if (this.isValidSortCondition(condition, projectVars)) continue;
                ok = false;
                break;
            }
            if (ok) {
                OpProject newProject = new OpProject(order.getSubOp(), project.getVars());
                OpDistinct newDistinct = new OpDistinct(newProject);
                return new OpOrder(newDistinct, order.getConditions());
            }
        }
        return super.transform(opDistinct, subOp);
    }

    @Override
    public Op transform(OpReduced opReduced, Op subOp) {
        OpProject project;
        if (subOp instanceof OpProject && (project = (OpProject)subOp).getSubOp() instanceof OpOrder) {
            List<Var> projectVars = project.getVars();
            OpOrder order = (OpOrder)project.getSubOp();
            boolean ok = true;
            for (SortCondition condition : order.getConditions()) {
                if (this.isValidSortCondition(condition, projectVars)) continue;
                ok = false;
                break;
            }
            if (ok) {
                OpProject newProject = new OpProject(order.getSubOp(), project.getVars());
                Op newReduced = OpReduced.create(newProject);
                return new OpOrder(newReduced, order.getConditions());
            }
        }
        return super.transform(opReduced, subOp);
    }

    private boolean isValidSortCondition(SortCondition cond, List<Var> projectVars) {
        if (cond.getExpression().isVariable()) {
            return projectVars.contains((Object)cond.getExpression().asVar());
        }
        for (Var v : cond.getExpression().getVarsMentioned()) {
            if (projectVars.contains((Object)v)) continue;
            return false;
        }
        return true;
    }
}

