/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.lang;

import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.lang.ParseHandlerResolver;
import java.util.HashMap;
import java.util.Map;

public class ParseHandlerLink
extends ParseHandlerResolver {
    static final String tagLink = "link@";
    static final String tagName = "@name";
    String currentName = null;
    Map<String, Item> namedItems = new HashMap<String, Item>();

    public ParseHandlerLink(Prologue prologue) {
        super(prologue);
    }

    @Override
    public void parseFinish() {
        super.parseFinish();
    }

    @Override
    protected void declItem(ItemList list, Item item) {
        if (list.getFirst().isSymbol(tagLink)) {
            System.err.println("Not written: " + item);
            super.declItem(list, item);
            return;
        }
        if (list.getFirst().isSymbol(tagName)) {
            if (!item.isSymbol()) {
                ParseHandlerLink.throwException("Must be a symbol for a named item: " + item.shortString(), item);
            }
            if (this.namedItems.containsKey(item.getSymbol())) {
                ParseHandlerLink.throwException("Name already defined: " + item, item);
            }
            this.currentName = item.getSymbol();
            super.declItem(list, item);
            return;
        }
        super.declItem(list, item);
    }

    @Override
    protected boolean endOfDecl(ItemList list, Item item) {
        super.setFormResult(item);
        if (this.namedItems.containsKey(this.currentName)) {
            ParseHandlerLink.throwException("Name already defined: " + this.currentName, item);
        }
        this.namedItems.put(this.currentName, item);
        this.currentName = null;
        return super.endOfDecl(list, item);
    }

    @Override
    protected boolean isForm(Item tag) {
        if (tag.isSymbol(tagLink) || tag.isSymbol(tagName)) {
            return true;
        }
        return super.isForm(tag);
    }
}

