/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.mgt;

import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.engine.QueryEngineBase;
import com.hp.hpl.jena.sparql.mgt.ContextMBean;
import com.hp.hpl.jena.sparql.mgt.QueryEngineInfo;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.jena.atlas.logging.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ARQMgt {
    private static Logger log = LoggerFactory.getLogger(ARQMgt.class);
    private static boolean initialized = false;
    private static boolean noJMX = false;
    private static Map<ObjectName, Object> mgtObjects = new HashMap<ObjectName, Object>();
    private static MBeanServer mbs = null;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        try {
            mbs = ManagementFactory.getPlatformMBeanServer();
            String NS = "org.apache.jena.arq";
            ContextMBean cxtBean = new ContextMBean(ARQ.getContext());
            QueryEngineInfo qeInfo = QueryEngineBase.queryEngineInfo;
            ARQMgt.register(NS + ".system:type=Context", (Object)cxtBean);
            ARQMgt.register(NS + ".system:type=Engine", (Object)qeInfo);
        }
        catch (Throwable ex) {
            Log.warn(ARQMgt.class, "Failed to initialize JMX", ex);
            noJMX = true;
            mbs = null;
        }
    }

    public static void register(String name, Object bean) {
        ARQMgt.init();
        if (noJMX) {
            return;
        }
        ObjectName objName = ARQMgt.objectName(name);
        ARQMgt.register(objName, bean);
    }

    public static void unregister(String name) {
        ARQMgt.init();
        if (noJMX) {
            return;
        }
        ObjectName objName = ARQMgt.objectName(name);
        ARQMgt.unregister(objName);
    }

    private static void register(ObjectName objName, Object bean) {
        try {
            if (mbs.isRegistered(objName)) {
                try {
                    mbs.unregisterMBean(objName);
                }
                catch (InstanceNotFoundException ex) {
                    // empty catch block
                }
            }
            log.debug("Register MBean: " + objName);
            mbs.registerMBean(bean, objName);
            mgtObjects.put(objName, bean);
        }
        catch (NotCompliantMBeanException ex) {
            log.warn("Failed to register (NotCompliantMBeanException)'" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
        catch (InstanceAlreadyExistsException ex) {
            log.warn("Failed to register (InstanceAlreadyExistsException)'" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
        catch (MBeanRegistrationException ex) {
            log.warn("Failed to register (MBeanRegistrationException)'" + objName.getCanonicalName() + "': " + ex.getMessage());
            throw new ARQException("Failed to register '" + objName.getCanonicalName() + "': " + ex.getMessage(), ex);
        }
    }

    private static void unregister(ObjectName objName) {
        log.debug("Unregister MBean: " + objName);
        if (!mgtObjects.containsKey(objName)) {
            log.warn("MBean not already registered: " + objName);
        }
        try {
            mbs.unregisterMBean(objName);
        }
        catch (InstanceNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (MBeanRegistrationException ex) {
            ex.printStackTrace();
        }
    }

    private static ObjectName objectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException ex) {
            throw new ARQException("Failed to create name '" + name + "': " + ex.getMessage(), ex);
        }
    }
}

