/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transformer.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagInfoTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.transformer.Completer;
import gov.loc.repository.bagit.transformer.impl.CompleterHelper;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import java.util.Calendar;
import java.util.List;

public class UpdateCompleter
extends LongRunningOperationBase
implements Completer {
    private Manifest.Algorithm tagManifestAlgorithm = null;
    private Manifest.Algorithm payloadManifestAlgorithm = null;
    private Bag newBag;
    private BagFactory bagFactory;
    private CompleterHelper helper;
    private String nonDefaultManifestSeparator;
    private List<String> limitUpdatePayloadFilepaths = null;
    private List<String> limitDeletePayloadFilepaths = null;
    private List<String> limitAddPayloadFilepaths = null;
    private List<String> limitUpdatePayloadDirectories = null;
    private List<String> limitDeletePayloadDirectories = null;
    private List<String> limitAddPayloadDirectories = null;
    private List<String> limitUpdateTagFilepaths = null;
    private List<String> limitDeleteTagFilepaths = null;
    private List<String> limitAddTagFilepaths = null;
    private List<String> limitUpdateTagDirectories = null;
    private List<String> limitDeleteTagDirectories = null;
    private List<String> limitAddTagDirectories = null;

    public UpdateCompleter(BagFactory bagFactory) {
        this.bagFactory = bagFactory;
        this.helper = new CompleterHelper();
        this.addChainedCancellable(this.helper);
        this.addChainedProgressListenable(this.helper);
    }

    public void setLimitUpdatePayloadFilepaths(List<String> limitUpdateFiles) {
        this.limitUpdatePayloadFilepaths = limitUpdateFiles;
    }

    public void setLimitDeletePayloadFilepaths(List<String> limitDeleteFiles) {
        this.limitDeletePayloadFilepaths = limitDeleteFiles;
    }

    public void setLimitAddPayloadFilepaths(List<String> limitAddFiles) {
        this.limitAddPayloadFilepaths = limitAddFiles;
    }

    public void setLimitUpdatePayloadDirectories(List<String> limitUpdateDirectories) {
        this.limitUpdatePayloadDirectories = limitUpdateDirectories;
    }

    public void setLimitDeletePayloadDirectories(List<String> limitDeleteDirectories) {
        this.limitDeletePayloadDirectories = limitDeleteDirectories;
    }

    public void setLimitAddPayloadDirectories(List<String> limitAddDirectories) {
        this.limitAddPayloadDirectories = limitAddDirectories;
    }

    public void setLimitUpdateTagFilepaths(List<String> limitUpdateFiles) {
        this.limitUpdateTagFilepaths = limitUpdateFiles;
    }

    public void setLimitDeleteTagFilepaths(List<String> limitDeleteFiles) {
        this.limitDeleteTagFilepaths = limitDeleteFiles;
    }

    public void setLimitAddTagFilepaths(List<String> limitAddFiles) {
        this.limitAddTagFilepaths = limitAddFiles;
    }

    public void setLimitUpdateTagDirectories(List<String> limitUpdateDirectories) {
        this.limitUpdateTagDirectories = limitUpdateDirectories;
    }

    public void setLimitDeleteTagDirectories(List<String> limitDeleteDirectories) {
        this.limitDeleteTagDirectories = limitDeleteDirectories;
    }

    public void setLimitAddTagDirectories(List<String> limitAddDirectories) {
        this.limitAddTagDirectories = limitAddDirectories;
    }

    public void setNumberOfThreads(int num) {
        this.helper.setNumberOfThreads(num);
    }

    public void setTagManifestAlgorithm(Manifest.Algorithm tagManifestAlgorithm) {
        this.tagManifestAlgorithm = tagManifestAlgorithm;
    }

    public void setPayloadManifestAlgorithm(Manifest.Algorithm payloadManifestAlgorithm) {
        this.payloadManifestAlgorithm = payloadManifestAlgorithm;
    }

    @Override
    public Bag complete(Bag bag) {
        this.newBag = this.bagFactory.createBag(bag);
        this.newBag.putBagFiles(bag.getPayload());
        this.newBag.putBagFiles(bag.getTags());
        this.handleBagIt();
        this.handleBagInfo();
        this.handlePayloadManifests();
        this.handleTagManifests();
        if (this.isCancelled()) {
            return null;
        }
        return this.newBag;
    }

    protected void handleBagIt() {
        if (this.newBag.getBagItTxt() == null) {
            this.newBag.putBagFile(this.newBag.getBagPartFactory().createBagItTxt());
            if (this.limitAddTagFilepaths != null) {
                this.limitAddTagFilepaths.add(this.newBag.getBagConstants().getBagItTxt());
            }
        }
    }

    protected void handleBagInfo() {
        BagInfoTxt bagInfo = this.newBag.getBagInfoTxt();
        if (bagInfo == null) {
            return;
        }
        this.newBag.putBagFile(bagInfo);
        if (bagInfo.getPayloadOxum() != null) {
            bagInfo.generatePayloadOxum(this.newBag);
        }
        if (bagInfo.getBaggingDate() != null) {
            bagInfo.setBaggingDate(Calendar.getInstance().getTime());
        }
        if (bagInfo.getBagSize() != null) {
            bagInfo.generateBagSize(this.newBag);
        }
        if (this.limitUpdateTagFilepaths != null) {
            this.limitUpdateTagFilepaths.add(this.newBag.getBagConstants().getBagInfoTxt());
        }
    }

    protected void handleTagManifests() {
        if (this.newBag.getTagManifests().size() > 0) {
            this.helper.cleanManifests(this.newBag, this.newBag.getTagManifests(), this.limitDeleteTagFilepaths, this.limitDeleteTagDirectories);
            for (Manifest manifest : this.newBag.getTagManifests()) {
                this.helper.regenerateManifest(this.newBag, manifest, false, this.limitUpdateTagFilepaths, this.limitUpdateTagDirectories);
            }
            Manifest.Algorithm algorithm = this.tagManifestAlgorithm;
            if (algorithm == null) {
                algorithm = this.newBag.getTagManifests().get(0).getAlgorithm();
            }
            this.helper.handleManifest(this.newBag, algorithm, ManifestHelper.getTagManifestFilename(algorithm, this.newBag.getBagConstants()), this.newBag.getTags(), this.nonDefaultManifestSeparator, this.limitAddTagFilepaths, this.limitAddTagDirectories);
        }
    }

    protected void handlePayloadManifests() {
        this.helper.cleanManifests(this.newBag, this.newBag.getPayloadManifests(), this.limitDeletePayloadFilepaths, this.limitDeletePayloadDirectories);
        for (Manifest manifest : this.newBag.getPayloadManifests()) {
            this.helper.regenerateManifest(this.newBag, manifest, false, this.limitUpdatePayloadFilepaths, this.limitUpdatePayloadDirectories);
        }
        Manifest.Algorithm algorithm = this.payloadManifestAlgorithm;
        if (algorithm == null) {
            algorithm = this.newBag.getPayloadManifests().size() > 0 ? this.newBag.getPayloadManifests().get(0).getAlgorithm() : Manifest.Algorithm.MD5;
        }
        this.helper.handleManifest(this.newBag, algorithm, ManifestHelper.getPayloadManifestFilename(algorithm, this.newBag.getBagConstants()), this.newBag.getPayload(), this.nonDefaultManifestSeparator, this.limitAddPayloadFilepaths, this.limitAddPayloadDirectories);
        if (this.limitUpdateTagFilepaths != null) {
            for (Manifest manifest : this.newBag.getPayloadManifests()) {
                this.limitUpdateTagFilepaths.add(manifest.getFilepath());
            }
        }
    }

    public String getNonDefaultManifestSeparator() {
        return this.nonDefaultManifestSeparator;
    }

    public void setNonDefaultManifestSeparator(String manifestSeparator) {
        this.nonDefaultManifestSeparator = manifestSeparator;
    }
}

