/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import edu.ucsb.nceas.utilities.LSID;
import edu.ucsb.nceas.utilities.ParseLSIDException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LSIDUtil {
    private static final char COLON = ':';
    private static final char DOT = '.';
    private static final String LSIDPREFIX = "urn:lsid:";

    public static String transformToDocID(String LSID2) {
        String docid;
        block5: {
            docid = null;
            int counter = 0;
            int targetIndex = 3;
            boolean firstColonIndex = false;
            if (LSID2 != null) {
                try {
                    if (!LSID2.startsWith(LSIDPREFIX)) break block5;
                    for (int i = 0; i < LSID2.length(); ++i) {
                        char singleChar = LSID2.charAt(i);
                        if (singleChar == ':') {
                            ++counter;
                        }
                        if (counter != targetIndex) continue;
                        docid = LSID2.substring(1 + i);
                        docid = docid.replace(':', '.');
                        break;
                    }
                }
                catch (Exception e) {
                    docid = null;
                }
            }
        }
        return docid;
    }

    public static LSID parseLSID(String lsidString) throws ParseLSIDException {
        LSID lsid = new LSID();
        String regex = "urn:lsid:.+:.+:.*";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(lsidString);
        if (!matcher.matches()) {
            throw new ParseLSIDException("Could not parse lsid: " + lsidString);
        }
        String[] splitLSID = lsidString.split(":");
        lsid.setAuthority(splitLSID[2]);
        lsid.setNamespace(splitLSID[3]);
        lsid.setObjectId(splitLSID[4]);
        if (splitLSID.length > 4 && splitLSID[5] != "") {
            Long version = Long.valueOf(splitLSID[5]);
            lsid.setVersion(version);
        }
        return lsid;
    }

    public static String getDocId(String lsid, boolean includeRevision) throws ParseLSIDException {
        LSID parsedLSID = LSIDUtil.parseLSID(lsid);
        String docid = parsedLSID.getNamespace() + "." + parsedLSID.getObjectId();
        if (includeRevision && parsedLSID.getVersion() != null) {
            docid = docid + "." + parsedLSID.getVersion();
        }
        return docid;
    }
}

