/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprNode;
import com.hp.hpl.jena.sparql.expr.FunctionLabel;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;

public abstract class ExprFunction
extends ExprNode {
    protected FunctionLabel funcSymbol;
    protected String opSign;
    private List<Expr> argList = null;

    protected ExprFunction(String fName) {
        this.funcSymbol = new FunctionLabel(fName);
        this.opSign = null;
    }

    protected ExprFunction(String fName, String opSign) {
        this(fName);
        this.opSign = opSign;
    }

    public abstract Expr getArg(int var1);

    public abstract int numArgs();

    public List<Expr> getArgs() {
        if (this.argList != null) {
            return this.argList;
        }
        this.argList = new ArrayList<Expr>();
        for (int i = 1; i <= this.numArgs(); ++i) {
            this.argList.add(this.getArg(i));
        }
        return this.argList;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public ExprFunction getFunction() {
        return this;
    }

    @Override
    public int hashCode() {
        return this.funcSymbol.hashCode() ^ this.numArgs();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        ExprFunction ex = (ExprFunction)other;
        if (!this.funcSymbol.equals(ex.funcSymbol)) {
            return false;
        }
        if (this.numArgs() != ex.numArgs()) {
            return false;
        }
        for (int i = 1; i <= this.numArgs(); ++i) {
            Expr a2;
            Expr a1 = this.getArg(i);
            if (Lib.equal(a1, a2 = ex.getArg(i))) continue;
            return false;
        }
        return true;
    }

    public String getFunctionPrintName(SerializationContext cxt) {
        return this.funcSymbol.getSymbol();
    }

    public String getFunctionName(SerializationContext cxt) {
        return this.funcSymbol.getSymbol();
    }

    public FunctionLabel getFunctionSymbol() {
        return this.funcSymbol;
    }

    public String getFunctionIRI() {
        return null;
    }

    public String getOpName() {
        return this.opSign;
    }
}

