/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.sample;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.Condition;
import org.ecoinformatics.datamanager.database.ConnectionNotAvailableException;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;
import org.ecoinformatics.datamanager.database.Query;
import org.ecoinformatics.datamanager.database.SelectionItem;
import org.ecoinformatics.datamanager.database.TableItem;
import org.ecoinformatics.datamanager.database.WhereClause;
import org.ecoinformatics.datamanager.download.DataStorageInterface;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.QualityReport;
import org.ecoinformatics.datamanager.sample.EcogridEndPoint;
import org.ecoinformatics.datamanager.sample.SampleDataStorage;

public class SampleCallingApp
implements DatabaseConnectionPoolInterface {
    private static final String CONFIG_NAME = "datamanager";
    private static ResourceBundle options = null;
    private static String dbDriver = null;
    private static String dbURL = null;
    private static String dbUser = null;
    private static String dbPassword = null;
    private static String databaseAdapterName = null;
    private static String documentURL = null;
    private static String entityName = null;
    private static String packageID = null;
    private static Boolean qualityReporting = new Boolean("false");
    private DataManager dataManager;
    private InputStream metadataInputStream = null;
    private DataPackage dataPackage;
    private DataStorageInterface dsi = null;
    private EcogridEndPointInterface eepi = null;

    public SampleCallingApp() {
        SampleCallingApp.loadOptions();
        this.dataManager = DataManager.getInstance(this, databaseAdapterName);
        this.dsi = new SampleDataStorage();
        this.eepi = new EcogridEndPoint();
    }

    public static void main(String[] args) throws MalformedURLException, IOException, Exception {
        boolean success = true;
        SampleCallingApp dmm = new SampleCallingApp();
        dmm.setUp();
        success = success && dmm.testParseMetadata();
        success = success && dmm.testDownloadData();
        success = success && dmm.testLoadDataToDB();
        success = success && dmm.testSelectData();
        success = success && dmm.testEnumerationMethods();
        success = success && dmm.testQualityReport();
        System.err.println("Finished all tests, success = " + success + "\n");
        dmm.tearDown();
    }

    private static void loadOptions() {
        try {
            options = ResourceBundle.getBundle(CONFIG_NAME);
            dbDriver = options.getString("dbDriver");
            dbURL = options.getString("dbURL");
            dbUser = options.getString("dbUser");
            dbPassword = options.getString("dbPassword");
            databaseAdapterName = options.getString("dbAdapter");
            documentURL = options.getString("documentURL");
            entityName = options.getString("entityName");
            packageID = options.getString("packageID");
            String qualityReportingStr = options.getString("qualityReporting");
            String qualityReportTemplate = options.getString("qualityReportTemplate");
            if (qualityReportingStr != null) {
                if (qualityReportingStr.equalsIgnoreCase("true")) {
                    QualityReport.setQualityReporting(true, qualityReportTemplate);
                    String emlDereferencerXSLT = options.getString("emlDereferencerXSLT");
                    QualityReport.setEmlDereferencerXSLTPath(emlDereferencerXSLT);
                } else if (qualityReportingStr.equalsIgnoreCase("false")) {
                    QualityReport.setQualityReporting(false, null);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in loading options: " + e.getMessage());
        }
    }

    @Override
    public String getDBAdapterName() {
        return databaseAdapterName;
    }

    @Override
    public Connection getConnection() throws SQLException, ConnectionNotAvailableException {
        Connection connection = null;
        try {
            Class.forName(dbDriver);
        }
        catch (ClassNotFoundException e) {
            System.err.print("ClassNotFoundException: ");
            System.err.println(e.getMessage());
            throw new SQLException(e.getMessage());
        }
        try {
            connection = DriverManager.getConnection(dbURL, dbUser, dbPassword);
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        return connection;
    }

    @Override
    public boolean returnConnection(Connection conn) {
        boolean success = false;
        try {
            conn.close();
            success = true;
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    private void setUp() throws MalformedURLException, IOException, Exception {
        try {
            URL url = new URL(documentURL);
            this.metadataInputStream = url.openStream();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void tearDown() throws ClassNotFoundException, SQLException, Exception {
        if (this.dataPackage != null) {
            this.dataManager.dropTables(this.dataPackage);
            System.err.println("Finished dropping tables.\n");
        }
    }

    public boolean testDownloadData() {
        boolean success = false;
        DataStorageInterface[] dataStorageList = new DataStorageInterface[]{this.dsi};
        if (this.dataPackage != null) {
            success = this.dataManager.downloadData(this.dataPackage, this.eepi, dataStorageList);
        }
        System.err.println("Finished testDownloadData(), success = " + success + "\n");
        return success;
    }

    public boolean testEnumerationMethods() throws MalformedURLException, IOException, Exception {
        boolean success = false;
        String tableName = DataManager.getDBTableName(packageID, entityName);
        System.err.println("tableName: " + tableName);
        String[] fieldNames = DataManager.getDBFieldNames(packageID, entityName);
        if (fieldNames != null) {
            for (int i = 0; i < fieldNames.length; ++i) {
                System.err.println("  fieldNames[" + i + "]: " + fieldNames[i]);
            }
        }
        success = tableName != null && fieldNames != null;
        System.err.println("Finished testEnumerationMethods(), success = " + success + "\n");
        return success;
    }

    public boolean testLoadDataToDB() throws MalformedURLException, IOException, Exception {
        boolean success = false;
        if (this.dataPackage != null) {
            success = this.dataManager.loadDataToDB(this.dataPackage, this.eepi);
        }
        System.err.println("Finished testLoadDataToDB(), success = " + success + "\n");
        return success;
    }

    public boolean testParseMetadata() {
        boolean success = false;
        if (this.metadataInputStream != null) {
            try {
                this.dataPackage = this.dataManager.parseMetadata(this.metadataInputStream);
                success = this.dataPackage != null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.err.println("Finished testParseMetadata(), success = " + success + "\n");
        return success;
    }

    private boolean testQualityReport() {
        QualityReport qualityReport;
        boolean success = false;
        if (this.dataPackage != null && (qualityReport = this.dataPackage.getQualityReport()) != null) {
            File qualityReportFile = new File("/tmp/quality_report.xml");
            try {
                success = qualityReport.storeQualityReport(qualityReportFile);
            }
            catch (IOException e) {
                System.err.println("Error storing quality report file: " + e.getMessage());
            }
        }
        System.err.println("Finished testQualityReport(), success = " + success + "\n");
        return success;
    }

    public boolean testSelectData() throws Exception {
        boolean success;
        block9: {
            Entity entity = null;
            String operator = ">";
            success = false;
            int intValue = 1;
            Integer value = new Integer(intValue);
            ResultSet resultSet = null;
            if (this.dataPackage != null) {
                Entity[] entityList = this.dataPackage.getEntityList();
                entity = entityList[0];
                AttributeList attributeList = entity.getAttributeList();
                Attribute[] attributes = attributeList.getAttributes();
                Attribute attribute = attributes[2];
                DataPackage[] dataPackages = new DataPackage[]{this.dataPackage};
                Query query = new Query();
                SelectionItem selectionItem = new SelectionItem(entity, attribute);
                query.addSelectionItem(selectionItem);
                TableItem tableItem = new TableItem(entity);
                query.addTableItem(tableItem);
                Condition condition = new Condition(entity, attribute, operator, value);
                WhereClause whereClause = new WhereClause(condition);
                query.setWhereClause(whereClause);
                System.err.println("Query SQL = '" + query.toSQLString() + "'");
                try {
                    resultSet = this.dataManager.selectData(query, dataPackages);
                    if (resultSet != null) {
                        success = true;
                        int i = 1;
                        System.err.println("Printing all records with 'count' value greater than " + intValue);
                        while (resultSet.next()) {
                            int count = resultSet.getInt(1);
                            System.err.println("resultSet[" + i + "], count =  " + count);
                            ++i;
                        }
                        break block9;
                    }
                    throw new Exception("resultSet is null");
                }
                catch (Exception e) {
                    System.err.println("Exception in DataManager.selectData()" + e.getMessage());
                    throw e;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        System.err.println("Finished testSelectData(), success = " + success + "\n");
        return success;
    }
}

