/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities.triple;

import edu.ucsb.nceas.utilities.triple.Triple;
import edu.ucsb.nceas.utilities.triple.TripleParser;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Vector;

public class TripleCollection {
    private Vector<Triple> triples = new Vector();

    public TripleCollection() {
    }

    public TripleCollection(TripleCollection tc) {
        this.triples = tc.getCollection();
    }

    public TripleCollection(Reader xml) {
        TripleParser tp = new TripleParser(xml);
        this.triples = tp.getTriples().getCollection();
    }

    public TripleCollection(Vector<Triple> triples) {
        this.triples = (Vector)triples.clone();
    }

    public void addTriple(Triple triple) {
        this.triples.addElement(triple);
    }

    public boolean containsTriple(Triple triple) {
        return this.triples.removeElement(triple);
    }

    public Triple removeTriple(Triple triple) {
        boolean removed = this.triples.removeElement(triple);
        if (removed) {
            return triple;
        }
        return null;
    }

    public Vector<Triple> getCollectionBySubject(String subject) {
        Vector<Triple> trips = new Vector<Triple>();
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple trip = new Triple(this.triples.elementAt(i));
            if (!trip.getSubject().equals(subject)) continue;
            trips.addElement(trip);
        }
        return trips;
    }

    public Vector<Triple> getCollectionByRelationship(String relationship) {
        Vector<Triple> trips = new Vector<Triple>();
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple trip = new Triple(this.triples.elementAt(i));
            if (!trip.getRelationship().equals(relationship)) continue;
            trips.addElement(trip);
        }
        return trips;
    }

    public Vector<Triple> getCollectionByObject(String object) {
        Vector<Triple> trips = new Vector<Triple>();
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple trip = new Triple(this.triples.elementAt(i));
            if (!trip.getObject().equals(object)) continue;
            trips.addElement(trip);
        }
        return trips;
    }

    public Vector<Triple> getCollection() {
        return this.triples;
    }

    public String toXML() {
        return this.toXML(null);
    }

    public String toXML(String root) {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (root != null) {
            sb.append("<" + root + ">");
        }
        for (int i = 0; i < this.triples.size(); ++i) {
            sb.append(this.triples.elementAt(i).toXML());
        }
        if (root != null) {
            sb.append("</" + root + ">");
        }
        return sb.toString();
    }

    public String toFormatedXML() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.triples.size(); ++i) {
            sb.append(this.triples.elementAt(i).toFormatedXML());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < this.triples.size(); ++i) {
            Triple t = new Triple(this.triples.elementAt(i));
            sb.append(t.toString());
            if (i == this.triples.size() - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: TripleCollection <xml_file>");
            return;
        }
        String filename = args[0];
        try {
            InputStreamReader xml = new InputStreamReader((InputStream)new FileInputStream(filename), Charset.forName("UTF-8"));
            TripleCollection tc = new TripleCollection(xml);
            System.out.println("Triples are:");
            System.out.println(tc.toString());
            Vector<Triple> v = tc.getCollectionBySubject("1.s");
            System.out.println(v.toString());
            v = tc.getCollectionByObject("2.o");
            System.out.println(v.toString());
            v = tc.getCollectionByRelationship("1.r");
            System.out.println(v.toString());
            Triple t = new Triple("3.s", "3.r", "3.o");
            tc.addTriple(t);
            System.out.println(tc.toString());
            Triple u = tc.removeTriple(t);
            System.out.println(u.toString());
            System.out.println(tc.toString());
            Triple x = new Triple();
            u = tc.removeTriple(x);
            if (u != null) {
                System.out.println(u.toString());
            } else {
                System.out.println("u == null");
            }
            System.out.println(tc.toString());
            tc.addTriple(t);
            if (tc.containsTriple(t)) {
                System.out.println("it's there");
            } else {
                System.out.println("it's not");
            }
            tc.removeTriple(t);
            if (tc.containsTriple(t)) {
                System.out.println("it's there");
            } else {
                System.out.println("it's not");
            }
            tc.addTriple(t);
            System.out.println(tc.toXML());
            System.out.println(tc.toFormatedXML());
        }
        catch (Exception e) {
            System.out.println("error in main");
            e.printStackTrace(System.out);
        }
        System.out.println("Done with " + args[0]);
    }
}

