/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import com.sun.crypto.provider.SunJCE;
import edu.ucsb.nceas.utilities.KeyFileExistsException;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;

public class EncryptionUtil {
    private static String algorithm = "DESede";
    private static Cipher cipher = null;

    private EncryptionUtil() {
    }

    public static byte[] encrypt(Key key, String input) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (cipher == null) {
            EncryptionUtil.createCipher();
        }
        cipher.init(1, key);
        byte[] inputBytes = input.getBytes();
        return cipher.doFinal(inputBytes);
    }

    public static String decrypt(Key key, byte[] encryptionBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchAlgorithmException, NoSuchPaddingException {
        if (cipher == null) {
            EncryptionUtil.createCipher();
        }
        cipher.init(2, key);
        byte[] recoveredBytes = cipher.doFinal(encryptionBytes);
        String recovered = new String(recoveredBytes);
        return recovered;
    }

    public static void createNewKeyFile(String keyFileName) throws NoSuchAlgorithmException, KeyFileExistsException, InvalidKeySpecException, IOException {
        File keyFile = new File(keyFileName);
        if (keyFile.exists()) {
            throw new KeyFileExistsException("Cannot create encryption key file when one already exists: " + keyFileName);
        }
        SecretKey key = EncryptionUtil.generateKey();
        EncryptionUtil.writeKeyToFile(key, keyFile);
    }

    public static SecretKey generateKey() throws NoSuchAlgorithmException {
        KeyGenerator keygen = KeyGenerator.getInstance("DESede");
        return keygen.generateKey();
    }

    public static SecretKey readKeyFromFile(String keyFileName) throws IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        File keyFile = new File(keyFileName);
        DataInputStream in = new DataInputStream(new FileInputStream(keyFile));
        byte[] rawkey = new byte[(int)keyFile.length()];
        in.readFully(rawkey);
        in.close();
        DESedeKeySpec keyspec = new DESedeKeySpec(rawkey);
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
        SecretKey key = keyfactory.generateSecret(keyspec);
        return key;
    }

    public static void writeKeyToFile(SecretKey key, File f) throws IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory keyfactory = SecretKeyFactory.getInstance("DESede");
        DESedeKeySpec keyspec = (DESedeKeySpec)keyfactory.getKeySpec(key, DESedeKeySpec.class);
        byte[] rawkey = keyspec.getKey();
        FileOutputStream out = new FileOutputStream(f);
        out.write(rawkey);
        out.close();
    }

    private static void createCipher() throws NoSuchPaddingException, NoSuchAlgorithmException {
        try {
            cipher = Cipher.getInstance(algorithm);
        }
        catch (GeneralSecurityException gse) {
            SunJCE sunjce = new SunJCE();
            Security.addProvider(sunjce);
            cipher = Cipher.getInstance(algorithm);
        }
    }
}

