/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities.access;

import edu.ucsb.nceas.utilities.access.XMLAccessDAO;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DocInfoHandler
extends DefaultHandler {
    private Hashtable<String, String> _docinfo = new Hashtable();
    private String _currentTag = null;
    private XMLAccessDAO _currentAccessDAO = null;
    private String _accessPermOrder;
    private String _accessFileId;
    private String _subTreeId;
    private String _guid;
    private boolean _inPrincipal = false;
    private boolean _inPermission = false;
    private boolean _inAllow = false;
    private boolean _inDeny = false;
    private Vector<XMLAccessDAO> xmlAccessDAOList = new Vector();
    private Stack<XMLAccessDAO> xmlAccessDAOStack = new Stack();
    private String chars = "";

    public static String txtValue(int permission) {
        StringBuffer txtPerm = new StringBuffer();
        if ((permission & 7) == 7) {
            return "ALL";
        }
        if ((permission & 1) == 1) {
            txtPerm.append("CHANGEPERMISSION");
        }
        if ((permission & 4) == 4) {
            if (txtPerm.length() > 0) {
                txtPerm.append(",");
            }
            txtPerm.append("READ");
        }
        if ((permission & 2) == 2) {
            if (txtPerm.length() > 0) {
                txtPerm.append(",");
            }
            txtPerm.append("WRITE");
        }
        return txtPerm.toString();
    }

    public static int intValue(String permission) {
        int thisPermission = 0;
        try {
            thisPermission = new Integer(permission);
            if (thisPermission >= 0 && thisPermission <= 7) {
                return thisPermission;
            }
            thisPermission = -1;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (permission.toUpperCase().contains("CHANGEPERMISSION")) {
            thisPermission |= 1;
        }
        if (permission.toUpperCase().contains("READ")) {
            thisPermission |= 4;
        }
        if (permission.toUpperCase().contains("WRITE")) {
            thisPermission |= 2;
        }
        if (permission.toUpperCase().contains("ALL")) {
            thisPermission |= 7;
        }
        return thisPermission;
    }

    public DocInfoHandler() {
    }

    public DocInfoHandler(String guid) {
        this._guid = guid;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.chars = "";
        this._currentTag = localName;
        if (this._currentTag.equals("access")) {
            if (this._accessPermOrder == null) {
                this._accessPermOrder = attributes.getValue("order");
            }
            if (this._accessFileId == null) {
                this._accessFileId = attributes.getValue("accessfileid");
            }
            if (this._subTreeId == null) {
                this._subTreeId = attributes.getValue("subtreeid");
            }
        } else if (this._currentTag.equals("allow")) {
            this._inAllow = true;
        } else if (this._currentTag.equals("deny")) {
            this._inDeny = true;
        } else if (this._currentTag.equals("permission")) {
            this._inPermission = true;
        } else if (this._currentTag.equals("principal")) {
            this._inPrincipal = true;
            this._currentAccessDAO = new XMLAccessDAO();
            this._currentAccessDAO.setGuid(this._guid);
            this._currentAccessDAO.setPermOrder(this._accessPermOrder);
            this._currentAccessDAO.setAccessFileId(this._accessFileId);
            this._currentAccessDAO.setSubTreeId(this._subTreeId);
            if (this._inAllow) {
                this._currentAccessDAO.setPermType("allow");
            }
            if (this._inDeny) {
                this._currentAccessDAO.setPermType("deny");
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this._docinfo.put(this._currentTag, this.chars);
        if (this._currentTag.equals("principal") && this._inPrincipal) {
            if (this._currentAccessDAO != null) {
                this._currentAccessDAO.setPrincipalName(this.chars);
            }
        } else if (this._currentTag.equals("permission") && this._inPermission && this._currentAccessDAO != null) {
            String permString = this.chars;
            Long permLong = DocInfoHandler.intValue(permString);
            for (int i = 0; i < this.xmlAccessDAOStack.size(); ++i) {
                ((XMLAccessDAO)this.xmlAccessDAOStack.get(i)).addPermission(permLong);
            }
        }
        if (localName.equals("allow")) {
            this._inAllow = false;
        } else if (localName.equals("deny")) {
            this._inDeny = false;
        } else if (this._currentTag.equals("principal")) {
            this._inPrincipal = false;
            this.xmlAccessDAOStack.push(this._currentAccessDAO);
        } else if (this._currentTag.equals("permission")) {
            this._inPermission = false;
        }
        if (localName.equals("allow") || localName.equals("deny")) {
            this.xmlAccessDAOList.addAll(this.xmlAccessDAOStack);
            this.xmlAccessDAOStack.clear();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.chars = this.chars + new String(ch, start, length);
    }

    public Hashtable<String, String> getDocInfo() {
        return this._docinfo;
    }

    public Vector<XMLAccessDAO> getAccessControlList() {
        return this.xmlAccessDAOList;
    }
}

