/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeLimitedHttpClient
implements HttpClient {
    public static final String EXECUTE_TIMEOUT = "executeTimeout";
    protected final HttpClient client;
    protected final Executor executor;
    protected static final ThreadFactory DAEMON_THREAD_FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    };

    public TimeLimitedHttpClient(HttpClient client) {
        this(client, Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY));
    }

    public TimeLimitedHttpClient(HttpClient client, Executor executor) {
        this.client = client;
        this.executor = executor;
    }

    @Override
    public HttpResponseMessage execute(HttpMessage request, Map<String, Object> httpParameters) throws IOException {
        Object et = httpParameters.get(EXECUTE_TIMEOUT);
        if (et == null) {
            return this.client.execute(request, httpParameters);
        }
        long timeout = Long.parseLong(et.toString());
        Future<HttpResponseMessage> response = this.start(request, httpParameters);
        try {
            return response.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            SocketTimeoutException e2 = new SocketTimeoutException("no response after " + timeout + " msec");
            e2.initCause(e);
            throw e2;
        }
        catch (InterruptedException e) {
            InterruptedIOException e2 = new InterruptedIOException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        catch (ExecutionException e) {
            throw this.wrap(e.getCause());
        }
        catch (Exception e) {
            throw this.wrap(e);
        }
    }

    protected Future<HttpResponseMessage> start(HttpMessage request, Map<String, Object> httpParameters) {
        FutureTask<HttpResponseMessage> task = new FutureTask<HttpResponseMessage>(new Execute(this.client, request, httpParameters));
        this.executor.execute(task);
        return task;
    }

    protected IOException wrap(Throwable e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        IOException e2 = new IOException(e.getMessage());
        e2.initCause(e);
        return e2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Execute
    implements Callable<HttpResponseMessage> {
        protected final HttpClient client;
        protected final HttpMessage request;
        protected final Map<String, Object> httpParameters;

        protected Execute(HttpClient client, HttpMessage request, Map<String, Object> httpParameters) {
            this.client = client;
            this.request = request;
            this.httpParameters = httpParameters;
        }

        @Override
        public HttpResponseMessage call() throws IOException {
            return this.client.execute(this.request, this.httpParameters);
        }
    }
}

