/*
 * Decompiled with CFR 0.152.
 */
package tdb;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.StatsMatcher;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderLib;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformation;
import com.hp.hpl.jena.sparql.engine.optimizer.reorder.ReorderTransformationBase;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.writers.WriterNode;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.logging.Log;

public class tdbreorder {
    public static void main(String ... args) {
        BasicPattern bgp;
        if (args.length != 2) {
            System.err.println("Usage: PATTERN STATS");
            System.exit(1);
        }
        Log.enable(StatsMatcher.class);
        Log.enable(ReorderTransformationBase.class);
        if (args.length != 2) {
            System.err.println("Usage: op stats");
            System.exit(1);
        }
        String pattern = args[0];
        String statsFile = args[1];
        Op op = SSE.readOp((String)pattern);
        if (op instanceof OpQuadPattern) {
            bgp = ((OpQuadPattern)op).getBasicPattern();
        } else if (op instanceof OpBGP) {
            bgp = ((OpBGP)op).getPattern();
        } else {
            System.err.println("Not a quad or triple pattern");
            System.exit(2);
            bgp = null;
        }
        ReorderTransformation reorder = tdbreorder.chooseReorder(statsFile);
        BasicPattern bgp2 = reorder.reorder(bgp);
        System.out.println();
        tdbreorder.print(bgp);
        System.out.println();
        System.out.println(" ======== >>>>>>>>");
        tdbreorder.print(bgp2);
        System.out.println();
    }

    private static void print(BasicPattern bgp) {
        IndentedWriter out = IndentedWriter.stdout;
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        pmap.setNsPrefixes(SSE.defaultPrefixMapWrite);
        SerializationContext sCxt = SSE.sCxt((PrefixMapping)pmap);
        boolean first = true;
        for (Triple t : bgp) {
            if (!first) {
                out.print("\n");
            } else {
                first = false;
            }
            out.print("(");
            WriterNode.outputPlain((IndentedWriter)out, (Triple)t, (SerializationContext)sCxt);
            out.print(")");
        }
        out.flush();
    }

    private static ReorderTransformation chooseReorder(String filename) {
        if (filename.equals("fixed.opt")) {
            return ReorderLib.fixed();
        }
        if (filename.equals("none.opt")) {
            return ReorderLib.identity();
        }
        if (FileOps.exists((String)filename)) {
            return ReorderLib.weighted((String)filename);
        }
        throw new RuntimeException("No such file: " + filename);
    }
}

