/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.out;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.riot.out.CharSpace;
import org.apache.jena.riot.out.EscapeStr;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.out.NodeFormatterBase;

public class NodeFormatterNT
extends NodeFormatterBase {
    private final EscapeStr escapeProc;

    public NodeFormatterNT() {
        this(CharSpace.UTF8);
    }

    public NodeFormatterNT(CharSpace charSpace) {
        this.escapeProc = new EscapeStr(charSpace);
    }

    @Override
    public void formatURI(AWriter w, String uriStr) {
        w.print('<');
        this.escapeProc.writeURI(w, uriStr);
        w.print('>');
    }

    @Override
    public void formatVar(AWriter w, String name) {
        w.print('?');
        this.escapeProc.writeStr(w, name);
    }

    @Override
    public void formatBNode(AWriter w, String label) {
        w.print("_:");
        String lab = NodeFmtLib.encodeBNodeLabel(label);
        w.print(lab);
    }

    @Override
    public void formatLitString(AWriter w, String lex) {
        this.writeEscaped(w, lex);
    }

    private void writeEscaped(AWriter w, String lex) {
        w.print('\"');
        this.escapeProc.writeStr(w, lex);
        w.print('\"');
    }

    @Override
    public void formatLitLang(AWriter w, String lex, String langTag) {
        this.writeEscaped(w, lex);
        w.print('@');
        w.print(langTag);
    }

    @Override
    public void formatLitDT(AWriter w, String lex, String datatypeURI) {
        this.writeEscaped(w, lex);
        w.print("^^");
        this.formatURI(w, datatypeURI);
    }
}

