/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;

public class PipedRDFIterator<T>
implements Iterator<T>,
Closeable {
    public static final int DEFAULT_BUFFER_SIZE = 10000;
    private static final int ITERATOR_POLL_TIMEOUT = 1000;
    private static final TimeUnit ITERATOR_POLL_TIMEUNIT = TimeUnit.MILLISECONDS;
    private final BlockingQueue<T> queue;
    private final T endMarker = new Object();
    private volatile boolean closedByReader = false;
    private volatile boolean closedByWriter = false;
    private volatile boolean finished = false;
    private volatile Thread readSide;
    private volatile Thread writeSide;
    private boolean connected = false;
    private T slot;
    private final Object lock = new Object();
    private String baseIri;
    private final PrefixMap prefixes = PrefixMapFactory.createForInput();

    public PipedRDFIterator() {
        this(10000);
    }

    public PipedRDFIterator(int bufferSize) {
        this.queue = new ArrayBlockingQueue<T>(bufferSize);
    }

    public PipedRDFIterator(int bufferSize, boolean fair) {
        this.queue = new ArrayBlockingQueue<T>(bufferSize, fair);
    }

    @Override
    public boolean hasNext() {
        block8: {
            if (!this.connected) {
                throw new IllegalStateException("Pipe not connected");
            }
            if (this.closedByReader) {
                throw new RiotException("Pipe closed");
            }
            if (this.finished) {
                return false;
            }
            this.readSide = Thread.currentThread();
            if (this.slot != null) {
                return true;
            }
            do {
                try {
                    this.slot = this.queue.poll(1000L, ITERATOR_POLL_TIMEUNIT);
                }
                catch (InterruptedException e2) {
                    throw new CancellationException();
                }
                if (null != this.slot) break block8;
            } while (this.writeSide == null || this.writeSide.isAlive() || this.closedByWriter);
            this.closedByReader = true;
            throw new RiotException("Write end dead");
        }
        if (this.slot == this.endMarker) {
            this.finished = true;
            this.slot = null;
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        T item = this.slot;
        this.slot = null;
        return item;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void checkStateForReceive() {
        if (this.closedByWriter || this.closedByReader) {
            throw new RiotException("Pipe closed");
        }
        if (this.readSide != null && !this.readSide.isAlive()) {
            throw new RiotException("Read end dead");
        }
    }

    protected void connect() {
        this.connected = true;
    }

    protected void receive(T t) {
        this.checkStateForReceive();
        this.writeSide = Thread.currentThread();
        try {
            this.queue.put(t);
        }
        catch (InterruptedException e2) {
            throw new CancellationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void base(String base) {
        Object object = this.lock;
        synchronized (object) {
            this.baseIri = base;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBaseIri() {
        Object object = this.lock;
        synchronized (object) {
            return this.baseIri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prefix(String prefix, String iri2) {
        Object object = this.lock;
        synchronized (object) {
            this.prefixes.add(prefix, iri2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrefixMap getPrefixes() {
        Object object = this.lock;
        synchronized (object) {
            return PrefixMapFactory.create(this.prefixes);
        }
    }

    protected void start() {
    }

    protected void finish() {
        this.receive(this.endMarker);
        this.closedByWriter = true;
    }

    @Override
    public void close() {
        this.closedByReader = true;
    }
}

