/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.web.auth;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.jena.atlas.web.auth.AbstractCredentialsAuthenticator;

public abstract class AbstractScopedAuthenticator<T>
extends AbstractCredentialsAuthenticator {
    @Override
    protected final String getUserName(URI target) {
        return this.getUserNameFromCredentials(this.findCredentials(target));
    }

    @Override
    protected final char[] getPassword(URI target) {
        return this.getPasswordFromCredentials(this.findCredentials(target));
    }

    @Override
    protected final boolean hasUserName(URI target) {
        return this.getUserName(target) != null;
    }

    @Override
    protected final boolean hasPassword(URI target) {
        return this.getPassword(target) != null;
    }

    protected abstract T getCredentials(URI var1);

    protected abstract String getUserNameFromCredentials(T var1);

    protected abstract char[] getPasswordFromCredentials(T var1);

    protected final T findCredentials(URI target) {
        T creds = this.getCredentials(target);
        try {
            while (creds == null) {
                if (target.getFragment() != null) {
                    target = new URI(target.getScheme(), target.getUserInfo(), target.getHost(), target.getPort(), target.getPath(), target.getQuery(), null);
                } else if (target.getQuery() != null) {
                    target = new URI(target.getScheme(), target.getUserInfo(), target.getHost(), target.getPort(), target.getPath(), null, null);
                } else if (target.getPath() != null) {
                    String currPath = target.getPath();
                    if (currPath.endsWith("/")) {
                        if ((currPath = currPath.substring(0, currPath.length() - 1)).length() == 0) {
                            currPath = null;
                        }
                        target = new URI(target.getScheme(), target.getUserInfo(), target.getHost(), target.getPort(), currPath, null, null);
                    } else if (currPath.contains("/")) {
                        if ((currPath = currPath.substring(0, currPath.lastIndexOf(47) + 1)).length() == 0) {
                            currPath = null;
                        }
                        target = new URI(target.getScheme(), target.getUserInfo(), target.getHost(), target.getPort(), currPath, null, null);
                    } else {
                        return null;
                    }
                }
                creds = this.getCredentials(target);
            }
            return creds;
        }
        catch (URISyntaxException e2) {
            return null;
        }
    }
}

