/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.ref;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.Algebra;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryEngineFactory;
import com.hp.hpl.jena.sparql.engine.QueryEngineRegistry;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.ref.QueryEngineRef;
import com.hp.hpl.jena.sparql.util.Context;

public class QueryEngineRefQuad
extends QueryEngineRef {
    private static QueryEngineFactory factory = new QueryEngineFactory(){

        @Override
        public boolean accept(Query query2, DatasetGraph dataset, Context context) {
            return true;
        }

        @Override
        public Plan create(Query query2, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineRefQuad engine = new QueryEngineRefQuad(query2, dataset, binding, context);
            return engine.getPlan();
        }

        @Override
        public boolean accept(Op op, DatasetGraph dataset, Context context) {
            return true;
        }

        @Override
        public Plan create(Op op, DatasetGraph dataset, Binding binding, Context context) {
            QueryEngineRefQuad engine = new QueryEngineRefQuad(op, dataset, binding, context);
            return engine.getPlan();
        }
    };

    public QueryEngineRefQuad(Op op, DatasetGraph dataset, Context context) {
        this(op, dataset, null, context);
    }

    public QueryEngineRefQuad(Op op, DatasetGraph dataset, Binding input, Context context) {
        super(op, dataset, input, context);
    }

    protected QueryEngineRefQuad(Query query2, DatasetGraph dataset, Binding input, Context context) {
        super(query2, dataset, input, context);
    }

    @Override
    protected Op modifyOp(Op op) {
        op = super.modifyOp(op);
        op = Algebra.toQuadForm(op);
        return op;
    }

    public static QueryEngineFactory getFactory() {
        return factory;
    }

    public static void register() {
        QueryEngineRegistry.addFactory(factory);
    }

    public static void unregister() {
        QueryEngineRegistry.removeFactory(factory);
    }
}

