/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.LabelExistsException;
import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.shared.Lock;
import com.hp.hpl.jena.sparql.ARQException;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphFactory;
import com.hp.hpl.jena.sparql.core.DatasetGraphMap;
import com.hp.hpl.jena.sparql.core.Transactional;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.NodeUtils;
import java.util.Iterator;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;

public class DatasetImpl
implements Dataset {
    protected DatasetGraph dsg = null;
    private Transactional transactional = null;
    private Cache<Graph, Model> cache = this.createCache();
    private Object internalLock = new Object();

    protected DatasetImpl(DatasetGraph dsg) {
        this.dsg = dsg;
        if (dsg instanceof Transactional) {
            this.transactional = (Transactional)((Object)dsg);
        }
    }

    public static Dataset wrap(DatasetGraph datasetGraph) {
        DatasetImpl ds = new DatasetImpl(datasetGraph);
        return ds;
    }

    public static Dataset cloneStructure(DatasetGraph datasetGraph) {
        return new DatasetImpl(new DatasetGraphMap(datasetGraph));
    }

    public DatasetImpl(Model model) {
        this.addToCache(model);
        this.dsg = DatasetGraphFactory.create(model.getGraph());
    }

    public DatasetImpl(Dataset ds) {
        this.dsg = DatasetGraphFactory.create(ds.asDatasetGraph());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getDefaultModel() {
        Object object = this.internalLock;
        synchronized (object) {
            return this.graph2model(this.dsg.getDefaultGraph());
        }
    }

    @Override
    public Lock getLock() {
        return this.dsg.getLock();
    }

    @Override
    public Context getContext() {
        return this.dsg.getContext();
    }

    @Override
    public boolean supportsTransactions() {
        return this.transactional != null;
    }

    @Override
    public void begin(ReadWrite mode) {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.begin(mode);
    }

    @Override
    public boolean isInTransaction() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        return this.transactional.isInTransaction();
    }

    @Override
    public void commit() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.commit();
    }

    @Override
    public void abort() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.abort();
    }

    @Override
    public void end() {
        if (this.transactional == null) {
            throw new UnsupportedOperationException("Transactions not supported");
        }
        this.transactional.end();
    }

    @Override
    public DatasetGraph asDatasetGraph() {
        return this.dsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        Object object = this.internalLock;
        synchronized (object) {
            Graph g = this.dsg.getGraph(n);
            if (g == null) {
                return null;
            }
            return this.graph2model(g);
        }
    }

    @Override
    public void addNamedModel(String uri, Model model) throws LabelExistsException {
        DatasetImpl.checkGraphName(uri);
        this.addToCache(model);
        Node n = NodeFactory.createURI((String)uri);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void removeNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
    }

    @Override
    public void replaceNamedModel(String uri, Model model) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        this.removeFromCache(this.dsg.getGraph(n));
        this.dsg.removeGraph(n);
        this.addToCache(model);
        this.dsg.addGraph(n, model.getGraph());
    }

    @Override
    public void setDefaultModel(Model model) {
        if (model == null) {
            model = ModelFactory.createDefaultModel();
        }
        this.removeFromCache(this.dsg.getDefaultGraph());
        this.addToCache(model);
        this.dsg.setDefaultGraph(model.getGraph());
    }

    @Override
    public boolean containsNamedModel(String uri) {
        DatasetImpl.checkGraphName(uri);
        Node n = NodeFactory.createURI((String)uri);
        return this.dsg.containsGraph(n);
    }

    @Override
    public Iterator<String> listNames() {
        return NodeUtils.nodesToURIs(this.dsg.listGraphNodes());
    }

    @Override
    public void close() {
        this.dsg.close();
        this.cache = null;
    }

    protected Cache<Graph, Model> createCache() {
        return CacheFactory.createCache(0.75f, 20);
    }

    protected void removeFromCache(Graph graph) {
        if (graph == null) {
            return;
        }
        this.cache.remove(graph);
    }

    protected void addToCache(Model model) {
        this.cache.put(model.getGraph(), model);
    }

    protected Model graph2model(Graph graph) {
        Model model = this.cache.get(graph);
        if (model == null) {
            model = ModelFactory.createModelForGraph((Graph)graph);
            this.cache.put(graph, model);
        }
        return model;
    }

    protected static void checkGraphName(String uri) {
        if (uri == null) {
            throw new ARQException("null for graph name");
        }
    }
}

