/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class TeeOutputStream
extends OutputStream {
    protected boolean closeCalled = false;
    private final boolean[] copyEnabled;
    protected final OutputStream[] destinations;
    private long size = 0L;
    private final long[] writeTime;

    public TeeOutputStream(OutputStream ... destinations) {
        this.checkDestinations(destinations);
        this.writeTime = new long[destinations.length];
        this.destinations = destinations;
        this.copyEnabled = new boolean[destinations.length];
        Arrays.fill(this.copyEnabled, true);
    }

    private void checkDestinations(OutputStream ... dests) {
        if (dests == null) {
            throw new IllegalArgumentException("Destinations OutputStream can't be null");
        }
        if (dests.length == 0) {
            throw new IllegalArgumentException("At least one destination OutputStream must be specified");
        }
        for (OutputStream destination : dests) {
            if (destination != null) continue;
            throw new IllegalArgumentException("One of the outputstreams in the array is null");
        }
    }

    public void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            int i = 0;
            while (i < this.destinations.length) {
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.close();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
    }

    public final void enableCopy(boolean enable) {
        Arrays.fill(this.copyEnabled, enable);
    }

    public final void enableCopy(boolean[] enable) {
        if (enable == null) {
            throw new IllegalArgumentException("Enable array can't be null");
        }
        if (enable.length != this.copyEnabled.length) {
            throw new IllegalArgumentException("Enable array must be of the same size of the OutputStream array passed in the constructor. Array size [" + enable.length + "] streams [" + this.copyEnabled.length + "]");
        }
        for (int i = 0; i < enable.length; ++i) {
            this.copyEnabled[i] = enable[i];
        }
    }

    public void flush() throws IOException {
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.flush();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
    }

    public final OutputStream[] getDestinationStreams() {
        return this.destinations;
    }

    public final long getSize() {
        return this.size;
    }

    public long[] getWriteTime() {
        return this.writeTime;
    }

    public void write(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("Array of bytes can't be null");
        }
        if (!this.closeCalled) {
            for (int i = 0; i < this.destinations.length; ++i) {
                if (!this.copyEnabled[i]) continue;
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b);
                int n = i;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            this.size += (long)b.length;
        } else {
            throw new IOException("Stream already closed.");
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Array of bytes can't be null");
        }
        if (!this.closeCalled) {
            for (int i = 0; i < this.destinations.length; ++i) {
                if (!this.copyEnabled[i]) continue;
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b, off, len);
                int n = i;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            this.size += (long)len;
        } else {
            throw new IOException("Stream already closed.");
        }
    }

    public void write(int b) throws IOException {
        if (!this.closeCalled) {
            for (int i = 0; i < this.destinations.length; ++i) {
                if (!this.copyEnabled[i]) continue;
                OutputStream stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b);
                ++this.size;
                int n = i;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            ++this.size;
        } else {
            throw new IOException("Attempt to write to a closed stream.");
        }
    }
}

