/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.ecoinformatics.datamanager.download.CompressedDataHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.Entity;

public class ZipDataHandler
extends CompressedDataHandler {
    protected ZipDataHandler(Entity entity, String url, EcogridEndPointInterface endPoint) {
        super(entity, url, endPoint);
    }

    protected ZipDataHandler(String url, EcogridEndPointInterface endPoint) {
        super(url, endPoint);
    }

    public static ZipDataHandler getZipHandlerInstance(Entity entity, String url, EcogridEndPointInterface endPoint) {
        ZipDataHandler zipHandler = (ZipDataHandler)ZipDataHandler.getHandlerFromHash(url);
        if (zipHandler == null) {
            zipHandler = new ZipDataHandler(entity, url, endPoint);
        }
        return zipHandler;
    }

    @Override
    protected boolean writeRemoteInputStreamIntoDataStorage(InputStream in) throws IOException {
        boolean success;
        block6: {
            success = false;
            ZipInputStream zipInputStream = null;
            if (in == null) {
                return success;
            }
            try {
                zipInputStream = new ZipInputStream(in);
                ZipEntry entry = zipInputStream.getNextEntry();
                int index = 0;
                if (entry != null) {
                    while (entry != null && index < 1) {
                        if (entry.isDirectory()) {
                            entry = zipInputStream.getNextEntry();
                            continue;
                        }
                        success = super.writeRemoteInputStreamIntoDataStorage(zipInputStream);
                        ++index;
                    }
                    break block6;
                }
                throw new IOException("No entries found in zip file.");
            }
            catch (Exception e) {
                String errorMsg = String.format("%s %s: %s", "Error reading from the data source.", "Error downloading zip file", e.getMessage());
                throw new IOException(errorMsg);
            }
        }
        return success;
    }

    @Override
    protected boolean getContentFromEcoGridSource(String endPoint, String ecogridIdentifier) {
        boolean success = false;
        File zipTmp = this.writeEcoGridCompressedDataIntoTmp(endPoint, ecogridIdentifier, ".1");
        try {
            if (zipTmp != null) {
                FileInputStream stream = new FileInputStream(zipTmp);
                success = this.writeRemoteInputStreamIntoDataStorage(stream);
            }
        }
        catch (Exception e) {
            System.out.println("Error is " + e.getMessage());
        }
        return success;
    }
}

