/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.utilities;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ThreadSafeIteratorWrapper<E>
implements Iterator<E>,
Iterable<E> {
    private E nextItem;
    private Iterator<E> iterator;

    public ThreadSafeIteratorWrapper(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        ThreadSafeIteratorWrapper threadSafeIteratorWrapper = this;
        synchronized (threadSafeIteratorWrapper) {
            Iterator<E> iterator = this.iterator;
            synchronized (iterator) {
                boolean hasNext = this.iterator.hasNext();
                this.nextItem = hasNext ? this.iterator.next() : null;
                return hasNext;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E next() {
        ThreadSafeIteratorWrapper threadSafeIteratorWrapper = this;
        synchronized (threadSafeIteratorWrapper) {
            if (this.nextItem == null) {
                throw new NoSuchElementException();
            }
            E tmp = this.nextItem;
            this.nextItem = null;
            return tmp;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

