/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.progresslistener;

import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.progresslistener.ProgressListenerHelper;
import java.io.Console;
import java.util.concurrent.atomic.AtomicBoolean;

public class ConsoleProgressListener
implements ProgressListener {
    private Console console = System.console();
    private long nextUpdate = System.currentTimeMillis();
    private int lastLineLength = 0;
    private AtomicBoolean updating = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportProgress(String activity, Object item, Long count, Long total) {
        long next;
        long now;
        if (this.console != null && (now = System.currentTimeMillis()) >= (next = this.nextUpdate)) {
            String msg = ProgressListenerHelper.format(activity, item, count, total);
            if (this.updating.compareAndSet(false, true)) {
                try {
                    int lastLength = this.lastLineLength;
                    this.backup(lastLength);
                    this.console.format(msg, new Object[0]);
                    if (msg.length() < lastLength) {
                        int spacesNeeded = lastLength - msg.length();
                        this.spaces(spacesNeeded);
                        this.backup(spacesNeeded);
                    }
                    this.console.flush();
                    this.lastLineLength = msg.length();
                    this.nextUpdate = now + 1000L;
                }
                finally {
                    this.updating.set(false);
                }
            }
        }
    }

    private void backup(int length) {
        for (int i = 0; i < length; ++i) {
            this.console.format("\b", new Object[0]);
        }
    }

    private void spaces(int length) {
        for (int i = 0; i < length; ++i) {
            this.console.format(" ", new Object[0]);
        }
    }
}

