/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database.pooling;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ecoinformatics.datamanager.database.ConnectionNotAvailableException;
import org.ecoinformatics.datamanager.database.DatabaseConnectionPoolInterface;

public class DatabaseConnectionPoolFactory {
    public static Log log = LogFactory.getLog(DatabaseConnectionPoolFactory.class);
    private static final String CONFIG_NAME = "datamanager";
    private static ResourceBundle options = null;
    private static String implementationClass = null;

    private static void loadOptions() {
        try {
            options = ResourceBundle.getBundle(CONFIG_NAME);
            implementationClass = options.getString("dbImplementationClass");
        }
        catch (Exception e) {
            System.out.println("Error in loading options: " + e.getMessage());
        }
    }

    public static DatabaseConnectionPoolInterface getDatabaseConnectionPoolInterface() {
        DatabaseConnectionPoolInterface instance = null;
        try {
            instance = (DatabaseConnectionPoolInterface)Class.forName(implementationClass).newInstance();
        }
        catch (Exception e) {
            log.error((Object)(e.getMessage() + ": could not create DatabaseConnectionPoolInterface implementation: " + implementationClass));
            e.printStackTrace();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] arg) {
        Connection conn = null;
        try {
            conn = DatabaseConnectionPoolFactory.getDatabaseConnectionPoolInterface().getConnection();
            log.debug((Object)("conn=" + conn));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ConnectionNotAvailableException e) {
            e.printStackTrace();
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    static {
        DatabaseConnectionPoolFactory.loadOptions();
    }
}

