/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.ecoinformatics.datamanager.database.Query;
import org.ecoinformatics.datamanager.database.SelectionItem;
import org.ecoinformatics.datamanager.database.UnWellFormedQueryException;
import org.ecoinformatics.datamanager.parser.Attribute;

public class Union {
    private List queryList = new ArrayList();
    private String unionType = "UNION ALL";
    private boolean orderQueryList = false;
    public static final String UNION = "UNION";
    public static final String UNION_ALL = "UNION ALL";

    public void addQuery(Query query) {
        this.queryList.add(query);
    }

    public String getUnionType() {
        return this.unionType;
    }

    public void setUnionType(String unionType) {
        this.unionType = unionType;
    }

    public boolean isOrderQueryList() {
        return this.orderQueryList;
    }

    public void setOrderQueryList(boolean orderQueryList) {
        this.orderQueryList = orderQueryList;
    }

    private String shearSemicolon(String input) {
        String temp = input;
        if (input.endsWith(";")) {
            temp = input.substring(0, input.lastIndexOf(";"));
        }
        return temp;
    }

    private void orderQueryList() {
        Query widestQuery = (Query)this.queryList.get(0);
        int widestSelectionCount = 0;
        for (Query query : this.queryList) {
            int attributeCount = query.getSelectionList().length;
            int nonNullAttributeCounter = 0;
            for (int i = 0; i < attributeCount; ++i) {
                SelectionItem selectionItem = query.getSelectionList()[i];
                Attribute attribute = selectionItem.getAttribute();
                if (attribute == null || widestSelectionCount >= (nonNullAttributeCounter = i)) continue;
                widestSelectionCount = nonNullAttributeCounter;
            }
            if (nonNullAttributeCounter != widestSelectionCount) continue;
            widestQuery = query;
        }
        this.queryList.remove(widestQuery);
        this.queryList.add(0, widestQuery);
    }

    private boolean validateQueryList() {
        boolean firstAttributeCount = false;
        for (Query query : this.queryList) {
            boolean attributeCount = false;
            if (firstAttributeCount == attributeCount) continue;
            return false;
        }
        return true;
    }

    public String toSQLString() throws UnWellFormedQueryException {
        StringBuffer sql = new StringBuffer();
        if (this.orderQueryList) {
            this.orderQueryList();
        }
        Iterator queryIter = this.queryList.iterator();
        while (queryIter.hasNext()) {
            Query query = (Query)queryIter.next();
            sql.append(this.shearSemicolon(query.toSQLString()));
            if (!queryIter.hasNext()) continue;
            sql.append(" ");
            sql.append(this.getUnionType());
            sql.append(" ");
        }
        sql.append(";");
        return sql.toString();
    }
}

