/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.security.Principal;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.dataone.bookkeeper.api.Address;
import org.dataone.service.types.v1.SubjectInfo;

@JsonIgnoreProperties(value={"discountJSON", "addressJSON", "metadataJSON", "invoiceSettingsJSON"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Customer
implements Principal {
    private Integer id;
    @NotEmpty
    @NotNull
    @Pattern(regexp="customer")
    private @NotEmpty @NotNull @Pattern(regexp="customer") String object;
    @NotEmpty
    @NotNull
    private String subject;
    private SubjectInfo subjectInfo;
    private Integer balance;
    private Address address;
    private Integer created;
    @Pattern(regexp="[A-Z]{3}")
    private @Pattern(regexp="[A-Z]{3}") String currency;
    private boolean delinquent;
    private String description;
    private ObjectNode discount;
    @NotEmpty
    @NotNull
    @Email
    private String email;
    private String invoicePrefix;
    private ObjectNode invoiceSettings;
    private ObjectNode metadata;
    @NotEmpty
    @NotNull
    private String givenName;
    @NotEmpty
    @NotNull
    private String surName;
    private String phone;

    public Customer() {
    }

    public Customer(Integer id, @NotEmpty @NotNull @Pattern(regexp="customer") @NotEmpty @NotNull @Pattern(regexp="customer") String object, @NotEmpty @NotNull String subject, Integer balance, Address address, Integer created, @Pattern(regexp="[A-Z]{3}") @Pattern(regexp="[A-Z]{3}") String currency, @NotNull boolean delinquent, @NotEmpty String description, ObjectNode discount, @NotEmpty @NotNull String email, String invoicePrefix, ObjectNode invoiceSettings, ObjectNode metadata, @NotEmpty @NotNull String givenName, @NotEmpty @NotNull String surName, String phone) {
        this.id = id;
        this.object = object;
        this.subject = subject;
        this.balance = balance;
        this.address = address;
        this.created = created;
        this.currency = currency;
        this.delinquent = delinquent;
        this.description = description;
        this.discount = discount;
        this.email = email;
        this.invoicePrefix = invoicePrefix;
        this.invoiceSettings = invoiceSettings;
        this.metadata = metadata;
        this.givenName = givenName;
        this.surName = surName;
        this.phone = phone;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getObject() {
        return this.object;
    }

    public void setObject(String object) {
        this.object = object;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public SubjectInfo getSubjectInfo() {
        return this.subjectInfo;
    }

    public void setSubjectInfo(SubjectInfo subjectInfo) {
        this.subjectInfo = subjectInfo;
    }

    public Integer getBalance() {
        return this.balance;
    }

    public void setBalance(Integer balance) {
        this.balance = balance;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public Integer getCreated() {
        return this.created;
    }

    public void setCreated(Integer created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean isDelinquent() {
        return this.delinquent;
    }

    public void setDelinquent(boolean delinquent) {
        this.delinquent = delinquent;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ObjectNode getDiscount() {
        return this.discount;
    }

    public void setDiscount(ObjectNode discount) {
        this.discount = discount;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getInvoicePrefix() {
        return this.invoicePrefix;
    }

    public void setInvoicePrefix(String invoicePrefix) {
        this.invoicePrefix = invoicePrefix;
    }

    public ObjectNode getInvoiceSettings() {
        return this.invoiceSettings;
    }

    public void setInvoiceSettings(ObjectNode invoiceSettings) {
        this.invoiceSettings = invoiceSettings;
    }

    public ObjectNode getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ObjectNode metadata) {
        this.metadata = metadata;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getSurName() {
        return this.surName;
    }

    public void setSurName(String surName) {
        this.surName = surName;
    }

    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getDiscountJSON() throws JsonProcessingException {
        if (this.discount != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getDiscount());
        }
        return "{}";
    }

    public String getAddressJSON() throws JsonProcessingException {
        if (this.address != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getAddress());
        }
        return "{}";
    }

    public String getInvoiceSettingsJSON() throws JsonProcessingException {
        if (this.invoiceSettings != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getInvoiceSettings());
        }
        return "{}";
    }

    public String getMetadataJSON() throws JsonProcessingException {
        if (this.metadata != null) {
            return new ObjectMapper().writeValueAsString((Object)this.getMetadata());
        }
        return "{}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Customer customer = (Customer)o;
        return this.isDelinquent() == customer.isDelinquent() && Objects.equals(this.getId(), customer.getId()) && Objects.equals(this.getBalance(), customer.getBalance()) && Objects.equals(this.getCreated(), customer.getCreated()) && Objects.equals(this.getObject(), customer.getObject()) && Objects.equals(this.getSubject(), customer.getSubject()) && Objects.equals(this.getAddress(), customer.getAddress()) && Objects.equals(this.getCurrency(), customer.getCurrency()) && Objects.equals(this.getDescription(), customer.getDescription()) && Objects.equals(this.getDiscount(), customer.getDiscount()) && Objects.equals(this.getEmail(), customer.getEmail()) && Objects.equals(this.getInvoicePrefix(), customer.getInvoicePrefix()) && Objects.equals(this.getInvoiceSettings(), customer.getInvoiceSettings()) && Objects.equals(this.getMetadata(), customer.getMetadata()) && Objects.equals(this.getGivenName(), customer.getGivenName()) && Objects.equals(this.getSurName(), customer.getSurName()) && Objects.equals(this.getPhone(), customer.getPhone());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getId(), this.getObject(), this.getSubject(), this.getBalance(), this.getAddress(), this.getCreated(), this.getCurrency(), this.isDelinquent(), this.getDescription(), this.getDiscount(), this.getEmail(), this.getInvoicePrefix(), this.getInvoiceSettings(), this.getMetadata(), this.getGivenName(), this.getSurName(), this.getPhone());
    }

    @Override
    public String getName() {
        return this.getSubject();
    }

    @Override
    public boolean implies(Subject subject) {
        return false;
    }
}

