/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.server;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.issuers.ATIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.AbstractIssuer;
import edu.uiuc.ncsa.security.delegation.server.request.ATRequest;
import edu.uiuc.ncsa.security.delegation.server.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.services.AddressableServer;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthUtilities;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import edu.uiuc.ncsa.security.oauth_1_0a.server.ATResponseImpl;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.net.URI;
import java.security.PublicKey;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;

public class ATIImpl
extends AbstractIssuer
implements ATIssuer {
    public ATIImpl(TokenForge tokenForge, URI address) {
        super(tokenForge, address);
    }

    public ATResponse processATRequest(ATRequest accessTokenRequest) {
        try {
            AuthorizationGrant ag;
            OAClient oaClient = (OAClient)accessTokenRequest.getClient();
            OAuthMessage message = OAuthUtilities.getMessage(accessTokenRequest.getServletRequest());
            Map<String, String> x = OAuthUtilities.getParameters(message);
            OAuthAccessor accessor = OAuthUtilities.createOAuthAccessor((AddressableServer)this, oaClient);
            if (oaClient.getSignatureMethod().equals("RSA-SHA1")) {
                PublicKey pk = KeyUtil.fromX509PEM((String)oaClient.getSecret());
                accessor.consumer.setProperty("RSA-SHA1.PublicKey", (Object)pk);
                accessor.setProperty("RSA-SHA1.PublicKey", (Object)pk);
            }
            if ((ag = accessTokenRequest.getAuthorizationGrant()) == null) {
                ag = this.tokenForge.getAuthorizationGrant(x);
                accessor.tokenSecret = null;
            } else {
                accessor.tokenSecret = ag.getSharedSecret();
            }
            OAuthUtilities.validate(message, accessor);
            if (accessTokenRequest.getVerifier() == null) {
                throw new GeneralException("Error, missing verifier");
            }
            AccessToken at = this.tokenForge.getAccessToken(new String[0]);
            ATResponseImpl atResp = new ATResponseImpl();
            atResp.setVerifier(accessTokenRequest.getVerifier());
            atResp.setAccessToken(at);
            atResp.setParameters(x);
            return atResp;
        }
        catch (Exception x) {
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new GeneralException((Throwable)x);
        }
    }
}

