/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.expr.nodevalue.XSDFuncOp;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.sse.writers.WriterExpr;
import com.hp.hpl.jena.sparql.util.ExprUtils;

public class AggAvgDistinct
extends AggregatorBase {
    private Expr expr;
    private static final NodeValue noValuesToAvg = NodeValue.nvZERO;

    public AggAvgDistinct(Expr expr) {
        this.expr = expr;
    }

    @Override
    public Aggregator copy(Expr expr) {
        return new AggAvgDistinct(expr);
    }

    @Override
    public String toString() {
        return "avg(distinct " + ExprUtils.fmtSPARQL(this.expr) + ")";
    }

    @Override
    public String toPrefixString() {
        return "(avg distinct " + WriterExpr.asString(this.expr) + ")";
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccAvgDistinct(this.expr);
    }

    @Override
    public final Expr getExpr() {
        return this.expr;
    }

    @Override
    public Node getValueEmpty() {
        return NodeValue.toNode(noValuesToAvg);
    }

    @Override
    public int hashCode() {
        return 0x171 ^ this.expr.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggAvgDistinct)) {
            return false;
        }
        AggAvgDistinct a = (AggAvgDistinct)other;
        return this.expr.equals(a.expr);
    }

    class AccAvgDistinct
    extends AccumulatorDistinctExpr {
        private NodeValue total;
        private int count;
        static final boolean DEBUG = false;

        public AccAvgDistinct(Expr expr) {
            super(expr);
            this.total = noValuesToAvg;
            this.count = 0;
        }

        @Override
        protected void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            if (nv.isNumber()) {
                ++this.count;
                this.total = this.total == noValuesToAvg ? nv : XSDFuncOp.numAdd(nv, this.total);
            } else {
                throw new ExprEvalException("avg: not a number: " + nv);
            }
        }

        @Override
        public NodeValue getAccValue() {
            if (this.count == 0) {
                return noValuesToAvg;
            }
            NodeValue nvCount = NodeValue.makeInteger(this.count);
            return XSDFuncOp.numDivide(this.total, nvCount);
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }
    }
}

