/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.optimize;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.TransformCopy;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpQuad;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpSequence;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpTriple;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.QuadPattern;
import java.util.List;

public class TransformPattern2Join
extends TransformCopy {
    @Override
    public Op transform(OpBGP opBGP) {
        return TransformPattern2Join.expand(opBGP.getPattern());
    }

    @Override
    public Op transform(OpQuadPattern quadPattern) {
        return TransformPattern2Join.expand(quadPattern.getPattern());
    }

    @Override
    public Op transform(OpSequence opSeq, List<Op> elts) {
        return TransformPattern2Join.expand(opSeq, elts);
    }

    private static Op expand(BasicPattern bgp) {
        if (bgp.getList().isEmpty()) {
            return OpTable.unit();
        }
        Op op = null;
        for (Triple t : bgp.getList()) {
            OpTriple x = new OpTriple(t);
            op = TransformPattern2Join.join(op, x);
        }
        return op;
    }

    private static Op expand(QuadPattern quads) {
        if (quads.getList().isEmpty()) {
            return OpTable.unit();
        }
        Op op = null;
        for (Quad q : quads.getList()) {
            OpQuad x = new OpQuad(q);
            op = TransformPattern2Join.join(op, x);
        }
        return op;
    }

    private static Op expand(OpSequence opSeq, List<Op> elts) {
        Op x = null;
        for (Op op : elts) {
            x = TransformPattern2Join.join(x, op);
        }
        return x;
    }

    private static Op join(Op left, Op right) {
        return OpJoin.createReduce(left, right);
    }
}

