/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.convert.IConverter;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.service.cn.impl.v1.NodeRegistryService;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.util.NodelistUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WebUrlSolrField
extends SolrField {
    Map<String, String> nodeMap = null;
    private static final String V1_OBJECT_ENDPOINT = "/v1/object/";
    String nodesXPath = "//replica[replicationStatus/text()='completed']/replicaMemberNode/text()";
    XPathExpression nodesExpression = null;
    boolean onlyReferenceCNs = true;
    private static Logger logger = Logger.getLogger((String)WebUrlSolrField.class.getName());
    private NodeRegistryService nodeRegistryService;

    public WebUrlSolrField(String name, String xpath, String nodesXPath) {
        super(name, xpath);
        this.nodesXPath = nodesXPath;
    }

    public void setOnlyReferenceCNs(boolean onlyReferenceCNs) {
        this.onlyReferenceCNs = onlyReferenceCNs;
    }

    public boolean isNodeCN(String nodeName) {
        NodeReference nr = new NodeReference();
        nr.setValue(nodeName);
        try {
            org.dataone.service.types.v1.Node node = this.nodeRegistryService.getNode(nr);
            if (node != null) {
                return NodeType.CN.equals((Object)node.getType().xmlValue());
            }
            return false;
        }
        catch (ServiceFailure e) {
            e.printStackTrace();
            return false;
        }
        catch (NotFound e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void initExpression(XPath xpathObject) {
        super.initExpression(xpathObject);
        try {
            this.nodesExpression = xpathObject.compile(this.nodesXPath);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> getNodeMap() throws NotImplemented, ServiceFailure {
        if (this.nodeMap == null) {
            this.nodeMap = NodelistUtil.mapNodeList((org.dataone.service.types.v1.NodeList)this.nodeRegistryService.listNodes());
            logger.info((Object)("**********Found node registry with: " + this.nodeMap.size() + "."));
            logger.info((Object)("**********Node Map: " + this.nodeMap.toString()));
        }
        return this.nodeMap;
    }

    @Override
    public List<SolrElementField> processField(Document doc, XPathExpression expression, String name, IConverter converter, boolean multiValued, boolean xmlEscape) throws XPathExpressionException, IOException, SAXException, ParserConfigurationException {
        ArrayList<SolrElementField> fields = new ArrayList<SolrElementField>();
        try {
            String id = (String)expression.evaluate(doc, XPathConstants.STRING);
            if (converter != null) {
                id = converter.convert(id);
            }
            NodeList values = (NodeList)this.nodesExpression.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < values.getLength(); ++i) {
                String getUrl;
                Node n = values.item(i);
                String nodeValue = n.getNodeValue();
                if (!this.getNodeMap().containsKey(nodeValue)) continue;
                if (this.onlyReferenceCNs) {
                    if (!this.isNodeCN(nodeValue)) continue;
                    getUrl = this.getNodeMap().get(nodeValue) + V1_OBJECT_ENDPOINT + id;
                    if (converter != null) {
                        getUrl = converter.convert(getUrl);
                    }
                    if (xmlEscape) {
                        getUrl = StringEscapeUtils.escapeXml((String)getUrl);
                    }
                    fields.add(new SolrElementField(name, getUrl));
                    logger.info((Object)("GET URL = " + getUrl));
                    if (this.multivalue) continue;
                    return fields;
                }
                getUrl = this.getNodeMap().get(nodeValue) + V1_OBJECT_ENDPOINT + id;
                if (converter != null) {
                    getUrl = converter.convert(getUrl);
                }
                if (xmlEscape) {
                    getUrl = StringEscapeUtils.escapeXml((String)getUrl);
                }
                fields.add(new SolrElementField(name, getUrl));
                logger.info((Object)("GET URL = " + getUrl));
                if (this.multivalue) continue;
                return fields;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fields;
    }

    public void setNodeRegistryService(NodeRegistryService nrs) {
        this.nodeRegistryService = nrs;
    }
}

