/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.SolrField;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.w3c.dom.Document;

public class AbstractDocumentSubprocessor
implements IDocumentSubprocessor {
    private String matchDocument = null;
    private XPathExpression matchDocumentExpression = null;
    private List<SolrField> fieldList = new ArrayList<SolrField>();

    public String getMatchDocument() {
        return this.matchDocument;
    }

    public void setMatchDocument(String matchDocument) {
        this.matchDocument = matchDocument;
    }

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, Document doc) throws Exception {
        SolrDoc metaDocument = docs.get(identifier);
        for (SolrField solrField : this.fieldList) {
            try {
                metaDocument.getFieldList().addAll(solrField.getFields(doc, identifier));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return docs;
    }

    @Override
    public boolean canProcess(Document doc) throws XPathExpressionException {
        Boolean matches = (Boolean)this.matchDocumentExpression.evaluate(doc, XPathConstants.BOOLEAN);
        return matches == null ? false : matches;
    }

    @Override
    public void initExpression(XPath xpathObject) {
        try {
            this.matchDocumentExpression = xpathObject.compile(this.getMatchDocument());
            for (SolrField solrField : this.fieldList) {
                solrField.initExpression(xpathObject);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public List<SolrField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<SolrField> fieldList) {
        this.fieldList = fieldList;
    }
}

