/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.osti_elink.v2.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import edu.ucsb.nceas.osti_elink.OSTIElinkException;
import edu.ucsb.nceas.osti_elink.OSTIElinkNotFoundException;
import edu.ucsb.nceas.osti_elink.OSTIElinkService;
import edu.ucsb.nceas.osti_elink.OSTIServiceFactory;
import edu.ucsb.nceas.osti_elink.exception.PropertyNotFound;
import edu.ucsb.nceas.osti_elink.v2.response.JsonResponseHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.methods.HttpUriRequest;

public class OSTIv2XmlService
extends OSTIElinkService {
    public static final String OSTI_TOKEN = "osti_token";
    public static final String TOKEN_PATH_PROP_NAME = "ostiService.tokenPath";
    private static final String UPLOAD_SUFFIX = "elink2xml/upload";
    private static final String QUERY_SUFFIX = "elink2api";
    protected static String token;
    protected static String queryURL;

    public OSTIv2XmlService(String username, String password, String baseURL) {
        super(username, password, baseURL);
    }

    public OSTIv2XmlService(String username, String password, String baseURL, Properties properties) throws PropertyNotFound, IOException, OSTIElinkException {
        super(username, password, baseURL);
        this.properties = properties;
        this.constructBaseAndQueryURL();
        this.loadToken();
    }

    @Override
    public String getStatus(String doi) throws OSTIElinkException {
        String status = null;
        String metadata = this.getMetadata(doi);
        try {
            status = JsonResponseHandler.getPathValue(metadata, "workflow_status");
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException(e.getMessage());
        }
        if (status == null) {
            throw new OSTIElinkException("There is no workflow_status for " + doi + " in the query result:\n" + metadata);
        }
        if (status.equals("SA")) {
            status = "Saved";
        }
        log.debug((Object)("The status of " + doi + " is " + status));
        return status;
    }

    protected void loadToken() throws PropertyNotFound, IOException {
        token = System.getenv(OSTI_TOKEN);
        if (token == null) {
            String token_path = OSTIServiceFactory.getProperty(TOKEN_PATH_PROP_NAME, this.properties);
            log.info((Object)("Can't get the token from the environmental variable OSTI_TOKEN and will read it from a file " + token_path));
            token = FileUtils.readFileToString((File)new File(token_path), (String)"UTF-8");
        } else {
            log.info((Object)"It got the token from the environmental variable - osti_token");
        }
    }

    protected void constructBaseAndQueryURL() throws OSTIElinkException {
        log.info((Object)("The base URL from the property file is " + this.baseURL));
        String url = System.getenv("guid_doi_baseurl");
        if (url != null && !url.trim().equals("")) {
            log.info((Object)("The base URL from the env variable guid_doi_baseurl is " + url + " and the value overwrites the one from the property file"));
            this.baseURL = url;
        }
        if (this.baseURL == null) {
            throw new OSTIElinkException("The base URL for the osti service is null");
        }
        if (!this.baseURL.endsWith("/")) {
            this.baseURL = this.baseURL + "/";
        }
        queryURL = this.baseURL + QUERY_SUFFIX;
        this.baseURL = this.baseURL + UPLOAD_SUFFIX;
        log.info((Object)("The OSTI base url is " + this.baseURL + " and the query url is " + queryURL));
    }

    @Override
    protected void setHeaders(HttpUriRequest request) {
        request.addHeader("Accept", "application/xml");
        request.addHeader("Authorization", "Bearer " + token);
    }

    @Override
    protected void setGetHeaders(HttpUriRequest request) {
        request.addHeader("Authorization", "Bearer " + token);
    }

    @Override
    protected String getMetadata(String identifier, String type) throws OSTIElinkException {
        String metadata = null;
        if (identifier != null && !identifier.trim().equals("")) {
            identifier = OSTIv2XmlService.removeDOI(identifier);
            String url = null;
            try {
                url = queryURL + "/records?" + type + "=" + URLEncoder.encode("\"" + identifier + "\"", StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new OSTIElinkException("OSTIv2XmlService.getMetadata - couldn't encode the query url: " + e.getMessage());
            }
            log.info((Object)("The url sending to the service is " + url));
            byte[] response = this.sendRequest(1, url);
            metadata = new String(response);
            log.info((Object)("The response for id " + identifier + " is\n " + metadata));
            if (metadata == null || metadata.trim().equals("")) {
                throw new OSTIElinkException("OSTIv2XmlService.getMetadata - the response is blank. It means the token is invalid for looking " + identifier + ", which type is " + type);
            }
            if (!metadata.contains(identifier)) {
                if (metadata.equals("[]")) {
                    throw new OSTIElinkNotFoundException("OSTIv2XmlService.getMetadata - OSTI can't find the identifier " + identifier + ", which type is " + type + " since\n " + metadata);
                }
                throw new OSTIElinkException("OSTIv2XmlService.getMetadata - can't get the metadata for id " + identifier + " since\n " + metadata);
            }
        } else {
            throw new OSTIElinkException("OSTIv2XmlService.getMetadata - the given identifier can't be null or blank.");
        }
        return metadata;
    }

    @Override
    protected String parseOSTIidFromResponse(String metadata, String doi) throws OSTIElinkException {
        if (metadata == null || metadata.trim().equals("")) {
            throw new OSTIElinkException("The service can't parse the blank response to get the OSTI id for the DOI " + doi);
        }
        try {
            return JsonResponseHandler.getPathValue(metadata, "osti_id");
        }
        catch (JsonProcessingException e) {
            throw new OSTIElinkException(e.getMessage());
        }
    }

    protected String getBaseUrl() {
        return this.baseURL;
    }

    protected String getQueryURL() {
        return queryURL;
    }
}

