/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.ezid;

import edu.ucsb.nceas.ezid.EZIDException;
import edu.ucsb.nceas.ezid.EZIDService;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EZIDServiceRequest
implements Runnable {
    public static final int CREATE = 1;
    public static final int SETMETADATA = 2;
    public static final int DELETE = 3;
    public static final int SMARTCREATE = 4;
    private EZIDService ezid = null;
    private int method;
    private String identifier;
    private HashMap<String, String> metadata = null;
    protected static Log log = LogFactory.getLog(EZIDServiceRequest.class);

    protected EZIDServiceRequest(EZIDService ezid, int method, String identifier) {
        if (ezid == null) {
            throw new IllegalArgumentException("EZIDService argument must not be null.");
        }
        if (method < 1 || method > 4) {
            throw new IllegalArgumentException("Service must be an interger value between 1 and 4.");
        }
        if (identifier == null) {
            throw new IllegalArgumentException("Identifier must not be null.");
        }
        this.ezid = ezid;
        this.method = method;
        this.identifier = identifier;
    }

    protected EZIDServiceRequest(EZIDService ezid, int method, String identifier, HashMap<String, String> metadata) {
        this(ezid, method, identifier);
        this.metadata = metadata;
    }

    @Override
    public void run() {
        log.debug((Object)("Service to execute: " + this.method + "/" + this.identifier + "/" + this.metadata));
        try {
            switch (this.method) {
                case 1: {
                    String newID = this.ezid.createIdentifier(this.identifier, this.metadata);
                    log.debug((Object)("Completed CREATE request for: " + this.identifier));
                    break;
                }
                case 2: {
                    this.ezid.setMetadata(this.identifier, this.metadata);
                    log.debug((Object)("Completed SETMETADATA request for: " + this.identifier));
                    break;
                }
                case 3: {
                    this.ezid.deleteIdentifier(this.identifier);
                    log.debug((Object)("Completed DELETE request for: " + this.identifier));
                    break;
                }
                case 4: {
                    HashMap<String, String> existingMetadata = null;
                    try {
                        existingMetadata = this.ezid.getMetadata(this.identifier);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (existingMetadata == null) {
                        this.ezid.createIdentifier(this.identifier, this.metadata);
                    } else {
                        this.ezid.setMetadata(this.identifier, this.metadata);
                    }
                    log.debug((Object)("Completed SMARTCREATE request for: " + this.identifier));
                }
            }
        }
        catch (EZIDException e) {
            log.error((Object)("FAILED Request " + this.method + " for: " + this.identifier + ". " + e.getMessage()));
        }
    }

    public int getMethod() {
        return this.method;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public HashMap<String, String> getMetadata() {
        return this.metadata;
    }
}

