/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public class Options {
    private static Options options = null;
    private static Properties appConfig = null;
    private static File propertyFile = null;

    private Options(File propertyFile) throws IOException {
        appConfig = new Properties();
        Options.propertyFile = propertyFile;
        FileInputStream fis = new FileInputStream(propertyFile);
        appConfig.load(fis);
        fis.close();
    }

    public static Options initialize(File propertyFile) throws IOException {
        if (options == null) {
            options = new Options(propertyFile);
        }
        return options;
    }

    public static Options reload() throws IOException {
        options = new Options(propertyFile);
        return options;
    }

    public static Options getInstance() {
        return options;
    }

    public synchronized String getOption(String optionName) {
        String value = (String)appConfig.get(optionName);
        return value;
    }

    public synchronized void setOption(String key, String value) {
        appConfig.setProperty(key, value);
        this.storePropertyFile();
    }

    public Enumeration propertyNames() {
        return appConfig.propertyNames();
    }

    private void storePropertyFile() {
        try {
            FileOutputStream writer = new FileOutputStream(propertyFile);
            appConfig.store(writer, null);
            writer.close();
        }
        catch (IOException e) {
            System.err.println("Could save the new property into file");
        }
    }
}

