/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.download;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URL;
import org.ecoinformatics.datamanager.download.DownloadHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.ecogrid.authenticatedqueryservice.AuthenticatedQueryServiceGetToStreamClient;
import org.ecoinformatics.ecogrid.queryservice.QueryServiceGetToStreamClient;

public abstract class CompressedDataHandler
extends DownloadHandler {
    protected CompressedDataHandler(Entity entity, String url, EcogridEndPointInterface endPoint) {
        super(entity, url, endPoint);
    }

    protected CompressedDataHandler(String url, EcogridEndPointInterface endPoint) {
        super(url, endPoint);
    }

    protected File writeEcoGridCompressedDataIntoTmp(String endPoint, String ecogridIdentifier, String suffix) {
        File compressedFile = null;
        if (endPoint != null && ecogridIdentifier != null) {
            try {
                String localIdentifier = ecogridIdentifier + suffix;
                File tmp = new File(System.getProperty("java.io.tmpdir"));
                compressedFile = new File(tmp, localIdentifier);
                FileOutputStream stream = new FileOutputStream(compressedFile);
                if (stream != null) {
                    BufferedOutputStream bos = new BufferedOutputStream(stream);
                    URL endPointURL = new URL(endPoint);
                    if (this.sessionId != null) {
                        AuthenticatedQueryServiceGetToStreamClient authenticatedEcogridClient = new AuthenticatedQueryServiceGetToStreamClient(endPointURL);
                        authenticatedEcogridClient.get(ecogridIdentifier, this.sessionId, (OutputStream)bos);
                    } else {
                        QueryServiceGetToStreamClient ecogridClient = new QueryServiceGetToStreamClient(endPointURL);
                        ecogridClient.get(ecogridIdentifier, (OutputStream)bos);
                    }
                    bos.flush();
                    bos.close();
                    stream.close();
                }
            }
            catch (Exception ee) {
                System.out.println("Error: " + ee.getMessage());
            }
        }
        return compressedFile;
    }
}

