/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.verify.impl;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.utilities.LongRunningOperationBase;
import gov.loc.repository.bagit.utilities.MessageDigestHelper;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.utilities.SimpleResultHelper;
import gov.loc.repository.bagit.utilities.ThreadSafeIteratorWrapper;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.ManifestChecksumVerifier;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParallelManifestChecksumVerifier
extends LongRunningOperationBase
implements ManifestChecksumVerifier,
FailModeSupporting {
    private static final Log log = LogFactory.getLog(ParallelManifestChecksumVerifier.class);
    private FailModeSupporting.FailMode failMode = FailModeSupporting.FailMode.FAIL_STAGE;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int num) {
        if (num < 1) {
            throw new IllegalArgumentException("Number of threads must be at least 1.");
        }
        this.numberOfThreads = num;
    }

    @Override
    public FailModeSupporting.FailMode getFailMode() {
        return this.failMode;
    }

    @Override
    public void setFailMode(FailModeSupporting.FailMode failMode) {
        this.failMode = failMode;
    }

    @Override
    public SimpleResult verify(Manifest manifest, Bag bag) {
        ArrayList<Manifest> manifests = new ArrayList<Manifest>();
        return this.verify(manifests, bag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleResult verify(List<Manifest> manifests, final Bag bag) {
        log.debug((Object)MessageFormat.format("Verifying manifests on {0} threads.", this.numberOfThreads));
        SimpleResult finalResult = new SimpleResult(true);
        int manifestCount = 0;
        int manifestTotal = manifests.size();
        for (final Manifest manifest : manifests) {
            if (this.isCancelled()) {
                return null;
            }
            this.progress("verifying manifest checksums", (Object)manifest.getFilepath(), ++manifestCount, manifestTotal);
            final Manifest.Algorithm alg = manifest.getAlgorithm();
            final Iterator manifestIterator = manifest.keySet().iterator();
            ArrayList<Future<SimpleResult>> futures = new ArrayList<Future<SimpleResult>>(this.numberOfThreads);
            final AtomicBoolean failFast = new AtomicBoolean(false);
            ExecutorService threadPool = Executors.newCachedThreadPool();
            try {
                final int fileTotal = manifest.size();
                final AtomicInteger fileCount = new AtomicInteger();
                for (int i = 0; i < this.numberOfThreads; ++i) {
                    Future<SimpleResult> future = threadPool.submit(new Callable<SimpleResult>(){

                        @Override
                        public SimpleResult call() {
                            ThreadSafeIteratorWrapper safeIterator = new ThreadSafeIteratorWrapper(manifestIterator);
                            SimpleResult result = new SimpleResult(true);
                            for (String filePath : safeIterator) {
                                BagFile file;
                                if (ParallelManifestChecksumVerifier.this.isCancelled()) {
                                    return null;
                                }
                                if (FailModeSupporting.FailMode.FAIL_FAST == ParallelManifestChecksumVerifier.this.failMode && failFast.get()) {
                                    return result;
                                }
                                ParallelManifestChecksumVerifier.this.progress("verifying file checksum", filePath, fileCount.incrementAndGet(), fileTotal);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)MessageFormat.format("Verifying {1} fixity for file: {0}", filePath, alg.bagItAlgorithm));
                                }
                                if ((file = bag.getBagFile(filePath)) != null && file.exists()) {
                                    String fixity = (String)manifest.get(filePath);
                                    InputStream stream = null;
                                    try {
                                        stream = file.newInputStream();
                                        if (MessageDigestHelper.fixityMatches(stream, alg, fixity)) continue;
                                        if (manifest.isPayloadManifest()) {
                                            SimpleResultHelper.invalidPayloadFile(result, manifest.getFilepath(), filePath);
                                        } else {
                                            SimpleResultHelper.invalidTagFile(result, manifest.getFilepath(), filePath);
                                        }
                                        String msg = MessageFormat.format("Fixity failure in manifest {0}: {1}", manifest.getFilepath(), filePath);
                                        log.debug((Object)msg);
                                        failFast.set(true);
                                        continue;
                                    }
                                    catch (RuntimeException ex) {
                                        throw new RuntimeException(MessageFormat.format("Error checking fixity of {0}: {1}", filePath, ex.getMessage()), ex);
                                    }
                                    finally {
                                        IOUtils.closeQuietly((InputStream)stream);
                                        continue;
                                    }
                                }
                                if (manifest.isPayloadManifest()) {
                                    SimpleResultHelper.missingPayloadFile(result, manifest.getFilepath(), filePath);
                                } else {
                                    SimpleResultHelper.missingTagFile(result, manifest.getFilepath(), filePath);
                                }
                                String msg = MessageFormat.format("File missing from manifest {0}: {1}", manifest.getFilepath(), filePath);
                                log.debug((Object)msg);
                                failFast.set(true);
                            }
                            return result;
                        }
                    });
                    futures.add(future);
                }
                for (Future<SimpleResult> future : futures) {
                    SimpleResult futureResult;
                    try {
                        futureResult = (SimpleResult)future.get();
                    }
                    catch (ExecutionException e) {
                        futureResult = new SimpleResult(false, e.getCause().getMessage());
                        log.error((Object)"An error occurred while processing the manifest.", e.getCause());
                    }
                    catch (InterruptedException e) {
                        futureResult = new SimpleResult(false, "Execution was interrupted before completion.");
                        log.error((Object)"Execution was interrupted before completion.", (Throwable)e);
                    }
                    finalResult.merge(futureResult);
                }
            }
            finally {
                log.debug((Object)"Shutting down thread pool.");
                threadPool.shutdown();
                log.debug((Object)"Thread pool shut down.");
            }
        }
        if (this.isCancelled()) {
            return null;
        }
        return finalResult;
    }
}

