/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */
package org.dataone.cn.indexer.convert;

import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.w3c.dom.Document;

import com.carrotsearch.randomizedtesting.annotations.ThreadLeakScope;

@ThreadLeakScope(ThreadLeakScope.Scope.NONE)
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "../../index/test-context.xml" })
public class MemberNodeServiceRegistrationTypeDocumentServiceTest {

    @Autowired
    private MemberNodeServiceRegistrationTypeDocumentService serviceTypeDocService;

    public MemberNodeServiceRegistrationTypeDocumentServiceTest() {
    }

    @Test
    public void testInjection() {
        Assert.assertNotNull(serviceTypeDocService);
        Assert.assertNotNull(serviceTypeDocService.getServiceTypeDocUrl());
        Assert.assertNotNull(serviceTypeDocService.getHttpClientFactory());
    }

    @Test
    public void testGetDocument() {
        Document doc = serviceTypeDocService.getMemberNodeServiceRegistrationTypeDocument();
        Assert.assertNotNull(doc);
    }

}
