/**
 * This work was created by participants in the DataONE project, and is
 * jointly copyrighted by participating institutions in DataONE. For 
 * more information on DataONE, see our web site at http://dataone.org.
 *
 *   Copyright ${year}
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 * 
 * $Id$
 */

package org.dataone.cn.indexer.convert;

/**
 * Created by IntelliJ IDEA.
 * User: Porter
 * Date: 8/9/11
 * Time: 5:17 PM
 */

/**Compares values and returns "true" or "false" if value matches expected
 *
 */
public class BooleanMatchConverter implements IConverter{
    private String matchValue = null;

    public BooleanMatchConverter(String matchValue) {
        this.setMatchValue(matchValue);
    }

    public String convert(String data) {

        if(data == null || data.trim().length() <= 0){
            return "false";
        }
        else if(data.equals(matchValue)){

            return "true";
        }
        return "false";
    }

    public String getMatchValue() {
        return matchValue;
    }

    public void setMatchValue(String matchValue) {
        this.matchValue = matchValue;
    }
}
