/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.lateral.LateralCache;
import org.apache.jcs.auxiliary.lateral.LateralCacheInfo;
import org.apache.jcs.auxiliary.lateral.behavior.ILateralCacheService;
import org.apache.jcs.engine.CacheAdaptor;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class LateralCacheNoWait
implements AuxiliaryCache {
    private static final long serialVersionUID = -7251187566116178475L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait == null ? (class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait = LateralCacheNoWait.class$("org.apache.jcs.auxiliary.lateral.LateralCacheNoWait")) : class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait));
    private final LateralCache cache;
    private ICacheEventQueue q;
    private int getCount = 0;
    private int removeCount = 0;
    private int putCount = 0;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$LateralCacheNoWait;

    public LateralCacheNoWait(LateralCache cache) {
        this.cache = cache;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructing LateralCacheNoWait, LateralCache = [" + cache + "]"));
        }
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.q = fact.createCacheEventQueue(new CacheAdaptor(cache), LateralCacheInfo.listenerId, cache.getCacheName(), cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
        if (cache.getStatus() == 3) {
            this.q.destroy();
        }
    }

    public void update(ICacheElement ce) throws IOException {
        ++this.putCount;
        try {
            this.q.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public ICacheElement get(Serializable key) {
        ++this.getCount;
        if (this.getStatus() != 3) {
            try {
                return this.cache.get(key);
            }
            catch (UnmarshalException ue) {
                log.debug((Object)"Retrying the get owing to UnmarshalException...");
                try {
                    return this.cache.get(key);
                }
                catch (IOException ex) {
                    log.error((Object)"Failed in retrying the get for the second time.");
                    this.q.destroy();
                }
            }
            catch (IOException ex) {
                this.q.destroy();
            }
        }
        return null;
    }

    public Set getGroupKeys(String groupName) {
        return this.cache.getGroupKeys(groupName);
    }

    public boolean remove(Serializable key) {
        ++this.removeCount;
        try {
            this.q.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
        return false;
    }

    public void removeAll() {
        try {
            this.q.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public void dispose() {
        try {
            this.q.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public int getSize() {
        return this.cache.getSize();
    }

    public int getCacheType() {
        return this.cache.getCacheType();
    }

    public int getStatus() {
        return this.q.isWorking() ? this.cache.getStatus() : 3;
    }

    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(ILateralCacheService lateral) {
        this.cache.fixCache(lateral);
        this.resetEventQ();
    }

    public void resetEventQ() {
        if (this.q.isWorking()) {
            this.q.destroy();
        }
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.q = fact.createCacheEventQueue(new CacheAdaptor(this.cache), LateralCacheInfo.listenerId, this.cache.getCacheName(), this.cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
    }

    public AuxiliaryCacheAttributes getAuxiliaryCacheAttributes() {
        return this.cache.getAuxiliaryCacheAttributes();
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Lateral Cache No Wait");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        IStats eqStats = this.q.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        StatElement se = null;
        se = new StatElement();
        se.setName("Get Count");
        se.setData("" + this.getCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Remove Count");
        se.setData("" + this.removeCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Put Count");
        se.setData("" + this.putCount);
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[elems.size()]);
        stats.setStatElements(ses);
        return stats;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" LateralCacheNoWait ");
        buf.append(" Status = " + this.getStatus());
        buf.append(" cache = [" + this.cache.toString() + "]");
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

