/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINReference;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBINReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;
import java.util.Comparator;

public final class DBIN
extends BIN
implements LoggableObject {
    private static final String BEGIN_TAG = "<dbin>";
    private static final String END_TAG = "</dbin>";
    private Key dupKey;

    public DBIN() {
        this.dupKey = new Key();
    }

    public DBIN(DatabaseImpl db, Key identifierKey, int maxEntriesPerNode, Key dupKey, int level) {
        super(db, identifierKey, maxEntriesPerNode, level);
        this.dupKey = dupKey;
    }

    protected IN createNewInstance(Key identifierKey, int maxEntries, int level) {
        return new DBIN(this.getDatabase(), identifierKey, maxEntries, this.dupKey, level);
    }

    protected int generateLevel(DatabaseId dbId, int newLevel) {
        return newLevel;
    }

    public final Comparator getKeyComparator() {
        return this.getDatabase().getDuplicateComparator();
    }

    public Key getDupKey() {
        return this.dupKey;
    }

    public Key getChildKey(IN child) throws DatabaseException {
        return child.getIdentifierKey();
    }

    public Key selectKey(Key mainTreeKey, Key dupTreeKey) {
        return dupTreeKey;
    }

    Key getDupTreeKey() {
        return this.getIdentifierKey();
    }

    public Key getMainTreeKey() {
        return this.dupKey;
    }

    public boolean containsDuplicates() {
        return true;
    }

    public LogEntryType getBINDeltaType() {
        return LogEntryType.LOG_DUP_BIN_DELTA;
    }

    public BINReference createReference() {
        return new DBINReference(this.getNodeId(), this.getDatabase().getId(), this.getIdentifierKey(), this.dupKey);
    }

    protected boolean canBeAncestor(Node target) {
        return target instanceof LN;
    }

    protected boolean childrenAreEvictable() {
        return true;
    }

    BIN getCursorBIN(CursorImpl cursor) {
        return cursor.getDupBIN();
    }

    int getCursorIndex(CursorImpl cursor) {
        return cursor.getDupIndex();
    }

    void setCursorBIN(CursorImpl cursor, BIN bin) {
        cursor.setDupBIN((DBIN)bin);
    }

    void setCursorIndex(CursorImpl cursor, int index) {
        cursor.setDupIndex(index);
    }

    boolean matchLNByNodeId(TreeLocation location, long nodeId) throws DatabaseException {
        for (int i = 0; i < this.getNEntries(); ++i) {
            LN ln;
            ChildReference ref = this.getEntry(i);
            if (ref == null || (ln = (LN)ref.fetchTarget(this.getDatabase(), this)) == null || ln.getNodeId() != nodeId) continue;
            location.bin = this;
            location.index = i;
            location.lnKey = new Key(ln.getData());
            location.childLsn = ref.getLsn();
            return true;
        }
        return false;
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.beginTag());
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dupkey>");
        sb.append(this.dupKey == null ? "" : this.dupKey.toString());
        sb.append("</dupkey>");
        sb.append('\n');
        sb.append(super.dumpString(nSpaces, false));
        sb.append(TreeUtils.indent(nSpaces));
        sb.append(this.endTag());
        return sb.toString();
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_DBIN;
    }

    public int getLogSize() {
        int size = super.getLogSize();
        return size += this.dupKey.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.dupKey.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        this.dupKey.readFromLog(itemBuffer);
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        super.dumpLogAdditional(sb);
        this.dupKey.dumpLog(sb, true);
    }

    public String shortClassName() {
        return "DBIN";
    }
}

