/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.OperationStatus;
import java.util.Set;

public class StoredValueSet
extends StoredCollection
implements Set {
    private boolean isSingleKey;

    public StoredValueSet(Database database, EntryBinding valueBinding, boolean writeAllowed) {
        super(new DataView(database, null, valueBinding, null, writeAllowed, null));
    }

    public StoredValueSet(Database database, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, null, null, valueEntityBinding, writeAllowed, null));
    }

    StoredValueSet(DataView valueSetView) {
        super(valueSetView);
    }

    StoredValueSet(DataView valueSetView, boolean isSingleKey) {
        super(valueSetView);
        this.isSingleKey = isSingleKey;
    }

    public boolean add(Object entity) {
        if (this.view.isSecondary()) {
            throw new UnsupportedOperationException("add() not allowed with index");
        }
        if (this.isSingleKey) {
            if (!this.view.dupsAllowed) {
                throw new UnsupportedOperationException("duplicates required");
            }
            DataCursor cursor = null;
            boolean doAutoCommit = this.beginAutoCommit();
            try {
                cursor = new DataCursor(this.view, true);
                cursor.useRangeKey();
                OperationStatus status = cursor.putNoDupData(null, entity, null, true);
                this.closeCursor(cursor);
                this.commitAutoCommit(doAutoCommit);
                return status == OperationStatus.SUCCESS;
            }
            catch (Exception e) {
                this.closeCursor(cursor);
                throw this.handleException(e, doAutoCommit);
            }
        }
        if (this.view.entityBinding == null) {
            throw new UnsupportedOperationException("add() requires entity binding");
        }
        return this.add(null, entity);
    }

    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    public boolean remove(Object value) {
        return this.removeValue(value);
    }

    public int size() {
        int n;
        DataCursor cursor;
        block6: {
            if (!this.isSingleKey) {
                return super.size();
            }
            cursor = null;
            cursor = new DataCursor(this.view, false);
            OperationStatus status = cursor.getFirst(false);
            if (status != OperationStatus.SUCCESS) break block6;
            int n2 = cursor.count();
            this.closeCursor(cursor);
            return n2;
        }
        try {
            n = 0;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return n;
    }

    Object makeIteratorData(StoredIterator iterator, DataCursor cursor) throws DatabaseException {
        return cursor.getCurrentValue();
    }

    boolean hasValues() {
        return true;
    }
}

