/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;

public class CurrentTransaction {
    private static WeakHashMap envMap = new WeakHashMap();
    private LockMode writeLockMode;
    private boolean cdbMode;
    private boolean txnMode;
    private Environment env;
    private ThreadLocal localTrans = new ThreadLocal();
    private ThreadLocal localCdbCursors;

    public static CurrentTransaction getInstance(Environment env) {
        CurrentTransaction currentTxn = CurrentTransaction.getInstanceInternal(env);
        return currentTxn.isTxnMode() ? currentTxn : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CurrentTransaction getInstanceInternal(Environment env) {
        WeakHashMap weakHashMap = envMap;
        synchronized (weakHashMap) {
            CurrentTransaction myEnv = (CurrentTransaction)envMap.get(env);
            if (myEnv == null) {
                myEnv = new CurrentTransaction(env);
                envMap.put(env, myEnv);
            }
            return myEnv;
        }
    }

    private CurrentTransaction(Environment env) {
        this.env = env;
        try {
            EnvironmentConfig config = env.getConfig();
            this.txnMode = config.getTransactional();
            this.writeLockMode = this.txnMode || DbCompat.getInitializeLocking(config) ? LockMode.RMW : LockMode.DEFAULT;
            this.cdbMode = DbCompat.getInitializeCDB(config);
            if (this.cdbMode) {
                this.localCdbCursors = new ThreadLocal();
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeExceptionWrapper(e);
        }
    }

    final boolean isTxnMode() {
        return this.txnMode;
    }

    final boolean isCdbMode() {
        return this.cdbMode;
    }

    final LockMode getWriteLockMode() {
        return this.writeLockMode;
    }

    public final Environment getEnvironment() {
        return this.env;
    }

    public final Transaction getTransaction() {
        Trans trans = (Trans)this.localTrans.get();
        return trans != null ? trans.txn : null;
    }

    public final Transaction beginTransaction(TransactionConfig config) throws DatabaseException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null) {
            if (trans.txn != null) {
                throw new IllegalStateException("Nested transactions are not supported");
            }
            trans.txn = this.env.beginTransaction(null, config);
            trans.config = config;
        } else {
            trans = new Trans(null, config);
            trans.txn = this.env.beginTransaction(null, config);
            this.localTrans.set(trans);
        }
        return trans.txn;
    }

    public final Transaction commitTransaction() throws DatabaseException, IllegalStateException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.txn != null) {
            Transaction parent = this.closeTxn(trans);
            trans.txn.commit();
            return parent;
        }
        throw new IllegalStateException("No transaction is active");
    }

    public final Transaction abortTransaction() throws DatabaseException, IllegalStateException {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.txn != null) {
            Transaction parent = this.closeTxn(trans);
            trans.txn.abort();
            return parent;
        }
        throw new IllegalStateException("No transaction is active");
    }

    final boolean isDirtyRead() {
        Trans trans = (Trans)this.localTrans.get();
        if (trans != null && trans.config != null) {
            return trans.config.getDirtyRead();
        }
        return false;
    }

    private Transaction closeTxn(Trans trans) {
        this.localTrans.set(trans.parent);
        return trans.parent != null ? trans.parent.txn : null;
    }

    Cursor openCursor(Database db, boolean writeCursor, Transaction txn) throws DatabaseException {
        if (this.cdbMode) {
            Cursor cursor;
            CursorConfig config;
            List cursors;
            CdbCursors cdbCursors = null;
            WeakHashMap<Database, CdbCursors> cdbCursorsMap = (WeakHashMap<Database, CdbCursors>)this.localCdbCursors.get();
            if (cdbCursorsMap == null) {
                cdbCursorsMap = new WeakHashMap<Database, CdbCursors>();
                this.localCdbCursors.set(cdbCursorsMap);
            } else {
                cdbCursors = (CdbCursors)cdbCursorsMap.get(db);
            }
            if (cdbCursors == null) {
                cdbCursors = new CdbCursors();
                cdbCursorsMap.put(db, cdbCursors);
            }
            if (writeCursor) {
                if (cdbCursors.readCursors.size() > 0) {
                    throw new IllegalStateException("cannot open CDB write cursor when read cursor is open");
                }
                cursors = cdbCursors.writeCursors;
                config = new CursorConfig();
                DbCompat.setWriteCursor(config, true);
            } else {
                cursors = cdbCursors.readCursors;
                config = null;
            }
            if (cursors.size() > 0) {
                Cursor other = (Cursor)cursors.get(0);
                cursor = other.dup(false);
            } else {
                cursor = db.openCursor(null, config);
            }
            cursors.add(cursor);
            return cursor;
        }
        return db.openCursor(txn, null);
    }

    Cursor dupCursor(Cursor cursor, boolean writeCursor, boolean samePosition) throws DatabaseException {
        if (this.cdbMode) {
            Database db;
            CdbCursors cdbCursors;
            WeakHashMap cdbCursorsMap = (WeakHashMap)this.localCdbCursors.get();
            if (cdbCursorsMap != null && (cdbCursors = (CdbCursors)cdbCursorsMap.get(db = cursor.getDatabase())) != null) {
                List cursors;
                List list = cursors = writeCursor ? cdbCursors.writeCursors : cdbCursors.readCursors;
                if (cursors.contains(cursor)) {
                    Cursor newCursor = cursor.dup(samePosition);
                    cursors.add(newCursor);
                    return newCursor;
                }
            }
            throw new IllegalStateException("cursor to dup not tracked");
        }
        return cursor.dup(samePosition);
    }

    void closeCursor(Cursor cursor) throws DatabaseException {
        if (cursor == null) {
            return;
        }
        if (this.cdbMode) {
            Database db;
            CdbCursors cdbCursors;
            WeakHashMap cdbCursorsMap = (WeakHashMap)this.localCdbCursors.get();
            if (cdbCursorsMap != null && (cdbCursors = (CdbCursors)cdbCursorsMap.get(db = cursor.getDatabase())) != null && (cdbCursors.readCursors.remove(cursor) || cdbCursors.writeCursors.remove(cursor))) {
                cursor.close();
                return;
            }
            throw new IllegalStateException("closing CDB cursor that was not known to be open");
        }
        cursor.close();
    }

    boolean isCDBCursorOpen(Database db) throws DatabaseException {
        CdbCursors cdbCursors;
        WeakHashMap cdbCursorsMap;
        return this.cdbMode && (cdbCursorsMap = (WeakHashMap)this.localCdbCursors.get()) != null && ((cdbCursors = (CdbCursors)cdbCursorsMap.get(db)) != null && cdbCursors.readCursors.size() > 0 || cdbCursors.writeCursors.size() > 0);
    }

    static final class CdbCursors {
        List writeCursors = new ArrayList();
        List readCursors = new ArrayList();

        CdbCursors() {
        }
    }

    private static class Trans {
        private Trans parent;
        private Transaction txn;
        private TransactionConfig config;

        private Trans(Trans parent, TransactionConfig config) {
            this.parent = parent;
            this.config = config;
        }
    }
}

