/*
 * Decompiled with CFR 0.152.
 */
package arq;

import arq.cmd.CmdException;
import arq.cmdline.ArgDecl;
import arq.cmdline.CmdARQ;
import arq.cmdline.ModEngine;
import arq.cmdline.ModQueryIn;
import arq.cmdline.ModQueryOut;
import com.hp.hpl.jena.query.Dataset;
import com.hp.hpl.jena.query.DatasetFactory;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryException;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.QueryCheckException;
import com.hp.hpl.jena.sparql.resultset.ResultSetException;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import com.hp.hpl.jena.sparql.util.QueryUtils;
import com.hp.hpl.jena.sparql.util.Utils;
import java.io.PrintStream;
import java.util.Iterator;

public class qparse
extends CmdARQ {
    ModQueryIn modQuery = new ModQueryIn();
    ModQueryOut modOutput = new ModQueryOut();
    ModEngine modEngine = new ModEngine();
    protected final ArgDecl argDeclPrint = new ArgDecl(true, "print");
    boolean printQuery = false;
    boolean printOp = false;
    boolean printQuad = false;
    boolean printPlan = false;
    static String usage = qparse.class.getName() + " [--in syntax] [--out syntax] [--print=FORM] [\"query\"] | --query <file>";
    static final String divider = "- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -";
    boolean needDivider = false;

    public static void main(String[] argv) {
        new qparse(argv).main();
    }

    public qparse(String[] argv) {
        super(argv);
        super.addModule(this.modQuery);
        super.addModule(this.modOutput);
        super.addModule(this.modEngine);
        super.getUsage().startCategory(null);
        super.add(this.argDeclPrint, "--print", "Print in various forms [query, op, quad, plan]");
    }

    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        Iterator iter = this.getValues(this.argDeclPrint).iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            if (arg.equalsIgnoreCase("query")) {
                this.printQuery = true;
                continue;
            }
            if (arg.equalsIgnoreCase("op") || arg.equalsIgnoreCase("alg") || arg.equalsIgnoreCase("algebra")) {
                this.printOp = true;
                continue;
            }
            if (arg.equalsIgnoreCase("quad")) {
                this.printQuad = true;
                continue;
            }
            if (arg.equalsIgnoreCase("plan")) {
                this.printPlan = true;
                continue;
            }
            throw new CmdException("Not a recognized print form: " + arg + " : Choices are: query, op, quad");
        }
        if (!(this.printQuery || this.printOp || this.printQuad || this.printPlan)) {
            this.printQuery = true;
        }
    }

    protected String getSummary() {
        return usage;
    }

    private void divider() {
        if (this.needDivider) {
            System.out.println(divider);
        }
        this.needDivider = true;
    }

    protected void exec() {
        try {
            Query query2;
            block14: {
                query2 = this.modQuery.getQuery();
                try {
                    QueryUtils.checkQuery((Query)query2);
                }
                catch (QueryCheckException ex) {
                    System.err.println();
                    System.err.println("**** Check failure: " + ex.getMessage());
                    if (ex.getCause() == null) break block14;
                    ex.getCause().printStackTrace(System.err);
                }
            }
            if (this.printQuery) {
                this.divider();
                this.modOutput.output(query2);
            }
            if (this.printOp) {
                this.divider();
                this.modOutput.outputOp(query2);
            }
            if (this.printQuad) {
                this.divider();
                this.modOutput.outputQuad(query2);
            }
            if (this.printPlan) {
                this.divider();
                QueryExecution qExec = QueryExecutionFactory.create((Query)query2, (Dataset)DatasetFactory.create());
                PrintUtils.printPlan((Query)query2, (QueryExecution)qExec);
            }
        }
        catch (ARQInternalErrorException intEx) {
            System.err.println(intEx.getMessage());
            if (intEx.getCause() != null) {
                System.err.println("Cause:");
                intEx.getCause().printStackTrace(System.err);
                System.err.println();
            }
            intEx.printStackTrace(System.err);
        }
        catch (ResultSetException ex) {
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
        }
        catch (QueryException qEx) {
            throw new CmdException("Query Exeception", qEx);
        }
        catch (JenaException ex) {
            ex.printStackTrace();
            throw ex;
        }
        catch (CmdException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new CmdException("Exception", ex);
        }
    }

    protected String getCommandName() {
        return Utils.className((Object)this);
    }

    static void writeSyntaxes(String msg, PrintStream out) {
        if (msg != null) {
            out.println(msg);
        }
        Iterator iter = Syntax.querySyntaxNames.keys();
        while (iter.hasNext()) {
            String k = (String)iter.next();
            Syntax v = Syntax.lookup((String)k);
            k = qparse.padOut(k, 10);
            out.println("  " + k + "  " + v);
        }
    }

    static String padOut(String x, int len) {
        StringBuffer r = new StringBuffer(x);
        for (int i = x.length(); i <= len; ++i) {
            r.append(" ");
        }
        return r.toString();
    }
}

