/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.pfunction;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.procedure.Procedure;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;

public class ProcedurePF
extends PrintSerializableBase
implements Procedure {
    private PropertyFunction propFunc;
    private PropFuncArg subjArg;
    private PropFuncArg objArg;
    private Node pfNode;

    public ProcedurePF(PropertyFunction propFunc, PropFuncArg subjArg, Node pfNode, PropFuncArg objArg) {
        this.propFunc = propFunc;
        this.subjArg = subjArg;
        this.pfNode = pfNode;
        this.objArg = objArg;
    }

    public QueryIterator proc(QueryIterator input, ExecutionContext execCxt) {
        return this.propFunc.exec(input, this.subjArg, this.pfNode, this.objArg, execCxt);
    }

    public void build(Node procId, ExprList args, ExecutionContext execCxt) {
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        out.print("ProcedurePF [" + FmtUtils.stringForNode(this.pfNode, sCxt) + "]");
        out.print("[");
        this.subjArg.output(out, sCxt);
        out.print("][");
        this.objArg.output(out, sCxt);
        out.print("]");
        out.println();
    }
}

