/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.optimizer;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.shared.PrefixMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ExplainFormatter {
    public static void printTable(StringBuffer out, String[] header, List rows, String left, String sep) {
        int[] colWidths = ExplainFormatter.colWidths(header, rows);
        ExplainFormatter.printLine(out, colWidths, left, sep);
        ExplainFormatter.printHeader(out, header, colWidths, left, sep);
        ExplainFormatter.printLine(out, colWidths, left, sep);
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            List row = (List)iter.next();
            StringBuffer bf = new StringBuffer(120);
            bf.append(left);
            for (int i = 0; i < row.size(); ++i) {
                String s = (String)row.get(i);
                bf.append(s);
                for (int j = 0; j < colWidths[i] - s.length(); ++j) {
                    bf.append(' ');
                }
                bf.append(sep);
            }
            out.append(bf + "\n");
        }
        ExplainFormatter.printLine(out, colWidths, left, sep);
    }

    public static List formatCols(PrefixMapping prefix, Triple triple1, Triple triple2, double cost) {
        ArrayList<String> cols = new ArrayList<String>();
        String subject1 = ExplainFormatter.formatNode(prefix, triple1.getSubject());
        String predicate1 = ExplainFormatter.formatNode(prefix, triple1.getPredicate());
        String object1 = ExplainFormatter.formatNode(prefix, triple1.getObject());
        String subject2 = ExplainFormatter.formatNode(prefix, triple2.getSubject());
        String predicate2 = ExplainFormatter.formatNode(prefix, triple2.getPredicate());
        String object2 = ExplainFormatter.formatNode(prefix, triple2.getObject());
        cols.add(subject1 + " " + predicate1 + " " + object1);
        cols.add(subject2 + " " + predicate2 + " " + object2);
        cols.add(ExplainFormatter.formatCost(cost));
        return cols;
    }

    public static List formatCols(PrefixMapping prefix, Triple triple, double cost) {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(ExplainFormatter.formatNode(prefix, triple.getSubject()));
        cols.add(ExplainFormatter.formatNode(prefix, triple.getPredicate()));
        cols.add(ExplainFormatter.formatNode(prefix, triple.getObject()));
        cols.add(ExplainFormatter.formatCost(cost));
        return cols;
    }

    private static void printHeader(StringBuffer out, String[] header, int[] colWidths, String left, String sep) {
        StringBuffer bf = new StringBuffer(120);
        bf.append(left);
        for (int i = 0; i < header.length; ++i) {
            String s = header[i];
            bf.append(s);
            for (int j = 0; j < colWidths[i] - s.length(); ++j) {
                bf.append(' ');
            }
            bf.append(sep);
        }
        out.append(bf + "\n");
    }

    private static void printLine(StringBuffer out, int[] colWidths, String left, String sep) {
        int i;
        StringBuffer bf = new StringBuffer(120);
        int tableLength = left.length();
        for (i = 0; i < colWidths.length; ++i) {
            tableLength += colWidths[i] + sep.length();
        }
        for (i = 0; i < tableLength - 1; ++i) {
            bf.append('-');
        }
        out.append(bf + "\n");
    }

    private static int[] colWidths(String[] header, List rows) {
        int[] colWidths = new int[header.length];
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            ArrayList row = (ArrayList)iter.next();
            for (int i = 0; i < row.size(); ++i) {
                String s = (String)row.get(i);
                if (s.length() <= colWidths[i]) continue;
                colWidths[i] = s.length();
            }
        }
        return colWidths;
    }

    private static String formatNode(PrefixMapping prefixMapping, Node node) {
        if (node.isVariable()) {
            return "?" + node.getName();
        }
        if (node.isBlank()) {
            return node.getBlankNodeLabel();
        }
        if (node.isURI()) {
            String prefix = prefixMapping.getNsURIPrefix(node.getNameSpace());
            if (prefix == null) {
                return "<" + node.getURI() + ">";
            }
            return prefix + ":" + node.getLocalName();
        }
        if (node.isLiteral()) {
            return '\"' + node.getLiteralLexicalForm() + '\"';
        }
        return null;
    }

    private static String formatCost(double cost) {
        if (cost <= 1.0) {
            return new Double(cost).toString();
        }
        return "NaN";
    }
}

