/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.speedbagit;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;

public class SpeedStream
extends FilterInputStream {
    private MessageDigest digest;
    private int size;

    public SpeedStream(InputStream in, MessageDigest sum) {
        super(in);
        this.digest = sum;
        this.size = 0;
        this.digest.reset();
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.digest.update((byte)b);
            ++this.size;
        }
        return b;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if ((len = this.in.read(buf, off, len)) != -1) {
            this.digest.update(buf, off, len);
            this.size += len;
        }
        return len;
    }

    public int getSize() {
        return this.size;
    }

    public String getChecksum() {
        return Hex.encodeHexString((byte[])this.digest.digest());
    }
}

