/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql.internals;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.core.util.Iso8601;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import java.net.URI;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;

public class ColumnMap
extends HashMap<String, Object>
implements ConversionMap<String, Object> {
    @Override
    public Object put(String key, Object value) {
        return super.put(key.toLowerCase(), value);
    }

    @Override
    public Object get(Object key) {
        return super.get(key.toString().toLowerCase());
    }

    @Override
    public String getString(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        return obj.toString();
    }

    @Override
    public long getLong(String key) {
        Object obj = this.get(key);
        if (obj instanceof Long) {
            return (Long)this.get(key);
        }
        if (obj == null) {
            return 0L;
        }
        return Long.parseLong(obj.toString());
    }

    @Override
    public boolean getBoolean(String key) {
        Object obj = this.get(key);
        if (obj instanceof Boolean) {
            return (Boolean)this.get(key);
        }
        if (obj == null) {
            return false;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    @Override
    public Date getDate(String key) {
        Object obj = this.get(key);
        if (obj instanceof Date) {
            return (Date)this.get(key);
        }
        try {
            return Iso8601.string2Date((String)obj.toString()).getTime();
        }
        catch (ParseException e) {
            throw new GeneralException("Error: Could not parse date\"" + obj + "\"", (Throwable)e);
        }
    }

    @Override
    public Identifier getIdentifier(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Identifier) {
            return (Identifier)obj;
        }
        return BasicIdentifier.newID((String)obj.toString());
    }

    @Override
    public URI getURI(String key) {
        Object obj = this.get(key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof URI) {
            return (URI)obj;
        }
        return URI.create(obj.toString());
    }

    @Override
    public byte[] getBytes(String key) {
        Object o = this.get(key.toLowerCase());
        if (o instanceof String && (o == null || ((String)o).length() == 0)) {
            return new byte[0];
        }
        return (byte[])o;
    }

    public Timestamp getTimestamp(String key) {
        return (Timestamp)this.get(key);
    }
}

