/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json.io;

import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNull;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.json.JsonVisitor;
import org.apache.jena.atlas.json.io.JSWriter;

public class JsonWriter
implements JsonVisitor {
    IndentedWriter out;
    private static String ArrayStart = "[ ";
    private static String ArrayFinish = " ]";
    private static String ArraySep = ",";
    private static String ObjectStart = "{ ";
    private static String ObjectFinish = "}";
    private static String ObjectSep = " ,";
    private static String ObjectPairSep = " : ";
    private static String SPC = " ";

    public JsonWriter() {
        this(IndentedWriter.stdout);
    }

    @Deprecated
    public JsonWriter(OutputStream ps) {
        this(new IndentedWriter(ps));
    }

    public JsonWriter(IndentedWriter ps) {
        this.out = ps;
    }

    public void startOutput() {
    }

    public void finishOutput() {
        this.out.flush();
    }

    @Override
    public void visit(JsonObject jsonObject) {
        this.out.print(ObjectStart);
        this.out.incIndent();
        boolean first = true;
        boolean multiLine = false;
        Set<String> x = jsonObject.keySet();
        TreeSet<String> y = new TreeSet<String>(x);
        for (String k : y) {
            if (!first) {
                this.out.print(ObjectSep);
                this.out.println();
                multiLine = true;
            }
            first = false;
            JSWriter.outputQuotedString(this.out, k);
            this.out.print(ObjectPairSep);
            this.out.incIndent();
            jsonObject.get(k).visit(this);
            this.out.decIndent();
        }
        this.out.decIndent();
        if (multiLine) {
            this.out.ensureStartOfLine();
        } else {
            this.out.print(SPC);
        }
        this.out.print(ObjectFinish);
    }

    @Override
    public void visit(JsonArray jsonArray) {
        boolean multiLine;
        boolean bl = multiLine = jsonArray.size() > 1;
        if (multiLine) {
            this.out.ensureStartOfLine();
        }
        this.out.print(ArrayStart);
        this.out.incIndent();
        boolean first = true;
        for (JsonValue elt : jsonArray) {
            if (!first) {
                this.out.print(ArraySep);
                this.out.println();
                multiLine = true;
            }
            first = false;
            elt.visit(this);
        }
        this.out.decIndent();
        if (multiLine) {
            this.out.ensureStartOfLine();
        }
        this.out.print(ArrayFinish);
    }

    @Override
    public void visit(JsonString jsonString) {
        JSWriter.outputQuotedString(this.out, jsonString.value());
    }

    @Override
    public void visit(JsonNumber jsonNumber) {
        this.out.print(jsonNumber.value().toString());
    }

    @Override
    public void visit(JsonBoolean jsonBoolean) {
        String x = jsonBoolean.value() ? "true" : "false";
        this.out.print(x);
    }

    @Override
    public void visit(JsonNull jsonNull) {
        this.out.print("null");
    }
}

