/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.util.Date;
import java.util.Vector;
import org.dataone.service.util.DateTimeMarshaller;
import org.dataone.service.util.EncodingUtilities;

public class D1Url {
    private String url;
    private String resource;
    private String baseUrl;
    private Vector<String> pathElements = new Vector();
    private Vector<String> paramV = new Vector();

    public D1Url(String baseUrl, String resource) throws IllegalArgumentException {
        this.setBaseUrl(baseUrl);
        this.setResource(resource);
    }

    public D1Url(String baseUrl) throws IllegalArgumentException {
        this.setBaseUrl(baseUrl);
    }

    public D1Url() {
    }

    public void setBaseUrl(String baseUrl) throws IllegalArgumentException {
        this.baseUrl = D1Url.trimAndValidateString(baseUrl);
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setResource(String res) {
        this.resource = res.trim();
    }

    public String getResource() {
        return this.resource;
    }

    public void addNextPathElement(String pathElement) throws IllegalArgumentException {
        this.pathElements.add(EncodingUtilities.encodeUrlPathSegment(D1Url.trimAndValidateString(pathElement)));
    }

    public void addNonEmptyParam(String param) {
        try {
            this.paramV.add(EncodingUtilities.encodeUrlQuerySegment(D1Url.trimAndValidateString(param)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void addNonEmptyParamPair(String key, String value) {
        try {
            this.paramV.add(EncodingUtilities.encodeUrlQuerySegment(D1Url.trimAndValidateString(key)) + "=" + EncodingUtilities.encodeUrlQuerySegment(D1Url.trimAndValidateString(value)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void addDateParamPair(String key, Date dateLocalTime) {
        if (dateLocalTime != null) {
            String dateString = DateTimeMarshaller.serializeDateToUTC(dateLocalTime);
            this.paramV.add(EncodingUtilities.encodeUrlQuerySegment(D1Url.trimAndValidateString(key)) + "=" + EncodingUtilities.encodeUrlQuerySegment(D1Url.trimAndValidateString(dateString)));
        }
    }

    public void addNonEmptyParamPair(String key, Integer integer) {
        if (integer != null) {
            this.paramV.add(EncodingUtilities.encodeUrlQuerySegment(D1Url.trimAndValidateString(key)) + "=" + EncodingUtilities.encodeUrlQuerySegment(D1Url.trimAndValidateString(integer.toString())));
        }
    }

    public void addPreEncodedNonEmptyQueryParams(String param) {
        try {
            this.paramV.add(D1Url.trimAndValidateString(param));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String getUrl() {
        this.assembleUrl();
        return this.url;
    }

    public String toString() {
        return this.getUrl();
    }

    protected void assembleUrl() {
        int i;
        this.url = this.baseUrl == null ? "" : this.baseUrl;
        this.url = this.url + this.joinToUrlWith("/", this.resource);
        for (i = 0; i < this.pathElements.size(); ++i) {
            this.url = this.url + this.joinToUrlWith("/", this.pathElements.get(i));
        }
        if (this.paramV.size() > 0) {
            this.url.replaceFirst("/$", "");
            this.url = this.url + this.joinToUrlWith("?", this.paramV.get(0));
        }
        for (i = 1; i < this.paramV.size(); ++i) {
            this.url = this.url + this.joinToUrlWith("&", this.paramV.get(i));
        }
    }

    public String getAssembledQueryString() {
        String queryParams = "";
        if (this.paramV.size() > 0) {
            queryParams = queryParams + this.paramV.get(0);
            for (int i = 1; i < this.paramV.size(); ++i) {
                queryParams = queryParams + "&";
                queryParams = queryParams + this.paramV.get(i);
            }
        }
        return queryParams;
    }

    protected static String trimAndValidateString(String s) throws IllegalArgumentException {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException("the string '" + s + "' cannot be null or empty or only whitespace");
        }
        return s.trim();
    }

    protected String joinToUrlWith(String joiner, String string) {
        if (string == null) {
            return "";
        }
        String joined = null;
        joined = this.url.endsWith(joiner) ? (string.startsWith(joiner) ? (String)string.subSequence(1, string.length()) : string) : (string.startsWith(joiner) ? string : joiner + string);
        return joined;
    }
}

