/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.CharProcedure;
import org.apache.mahout.math.function.CharShortProcedure;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractCharShortMap
extends AbstractSet {
    public boolean containsKey(final char key) {
        return !this.forEachKey(new CharProcedure(){

            public boolean apply(char iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final short value) {
        return !this.forEachPair(new CharShortProcedure(){

            public boolean apply(char iterKey, short iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractCharShortMap copy() {
        return (AbstractCharShortMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractCharShortMap)) {
            return false;
        }
        final AbstractCharShortMap other = (AbstractCharShortMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new CharShortProcedure(){

            public boolean apply(char key, short value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new CharShortProcedure(){

            public boolean apply(char key, short value) {
                return AbstractCharShortMap.this.containsKey(key) && AbstractCharShortMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(CharProcedure var1);

    public boolean forEachPair(final CharShortProcedure procedure) {
        return this.forEachKey(new CharProcedure(){

            public boolean apply(char key) {
                return procedure.apply(key, AbstractCharShortMap.this.get(key));
            }
        });
    }

    public abstract short get(char var1);

    public CharArrayList keys() {
        CharArrayList list = new CharArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final CharArrayList list) {
        list.clear();
        this.forEachKey(new CharProcedure(){

            public boolean apply(char key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(CharArrayList keyList) {
        this.pairsSortedByValue(keyList, new ShortArrayList(this.size()));
    }

    public void pairsMatching(final CharShortProcedure condition, final CharArrayList keyList, final ShortArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new CharShortProcedure(){

            public boolean apply(char key, short value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(CharArrayList keyList, ShortArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(CharArrayList keyList, ShortArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final char[] k = keyList.elements();
        final short[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                short t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                char t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(char var1, short var2);

    public abstract boolean removeKey(char var1);

    public String toString() {
        CharArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            char key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        CharArrayList theKeys = new CharArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            char key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public ShortArrayList values() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new CharProcedure(){

            public boolean apply(char key) {
                list.add(AbstractCharShortMap.this.get(key));
                return true;
            }
        });
    }

    public short adjustOrPutValue(char key, short newValue, short incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (short)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

