/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;

public abstract class FSTransactionStore<V extends BasicTransaction>
extends FileStore<V>
implements TransactionStore<V> {
    protected TokenForge tokenForge;

    protected FSTransactionStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> mp) {
        super(storeDirectory, indexDirectory, idp, mp);
        this.tokenForge = tokenForge;
    }

    public FSTransactionStore(File file, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> mp) {
        super(file, idp, mp);
        this.tokenForge = tokenForge;
    }

    public void realSave(boolean checkExists, V t) {
        super.realSave(checkExists, t);
        try {
            if (((BasicTransaction)((Object)t)).hasAuthorizationGrant()) {
                this.createIndexEntry(((BasicTransaction)((Object)t)).getAuthorizationGrant().getToken(), t.getIdentifierString());
            }
            if (((BasicTransaction)((Object)t)).hasAccessToken()) {
                this.createIndexEntry(((BasicTransaction)((Object)t)).getAccessToken().getToken(), t.getIdentifierString());
            }
            if (((BasicTransaction)((Object)t)).hasVerifier()) {
                this.createIndexEntry(((BasicTransaction)((Object)t)).getVerifier().getToken(), t.getIdentifierString());
            }
        }
        catch (IOException e) {
            throw new GeneralException("Error serializing item " + t + "to file ");
        }
    }

    public V realRemove(V thingie) {
        super.realRemove(thingie);
        if (((BasicTransaction)((Object)thingie)).getAccessToken() != null) {
            this.removeIndexEntry(((BasicTransaction)((Object)thingie)).getAccessToken().getToken());
        }
        if (((BasicTransaction)((Object)thingie)).getVerifier() != null) {
            this.removeIndexEntry(((BasicTransaction)((Object)thingie)).getVerifier().getToken());
        }
        return thingie;
    }

    @Override
    public V get(AuthorizationGrant authorizationGrant) {
        return (V)((Object)((BasicTransaction)this.getIndexEntry(authorizationGrant.getToken())));
    }

    @Override
    public V get(AccessToken accessToken) {
        return (V)((Object)((BasicTransaction)this.getIndexEntry(accessToken.getToken())));
    }

    @Override
    public V get(Verifier verifier) {
        return (V)((Object)((BasicTransaction)this.getIndexEntry(verifier.getToken())));
    }
}

