/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.web;

import com.hp.hpl.jena.Jena;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.JenaException;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.entity.ContentProducer;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.atlas.web.auth.HttpAuthenticator;
import org.apache.jena.atlas.web.auth.SimpleAuthenticator;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.system.IRILib;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpOp;
import org.apache.jena.riot.web.HttpResponseHandler;
import org.apache.jena.riot.web.HttpResponseLib;
import org.apache.jena.web.DatasetGraphAccessor;

public class DatasetGraphAccessorHTTP
implements DatasetGraphAccessor {
    private final String remote;
    private static final HttpResponseHandler noResponse = HttpResponseLib.nullResponse;
    private HttpAuthenticator authenticator;
    private static RDFFormat sendLang = RDFFormat.RDFXML_PLAIN;
    private static String GetAcceptHeader = "application/n-triples,text/turtle;q=0.9,application/rdf+xml;q=0.8,application/xml;q=0.7";
    private static HttpParams httpParams = DatasetGraphAccessorHTTP.createHttpParams();

    public DatasetGraphAccessorHTTP(String remote) {
        this.remote = remote;
    }

    public DatasetGraphAccessorHTTP(String remote, HttpAuthenticator authenticator) {
        this(remote);
        this.setAuthenticator(authenticator);
    }

    public void setAuthentication(String username, char[] password) {
        this.setAuthenticator(new SimpleAuthenticator(username, password));
    }

    public void setAuthenticator(HttpAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public Graph httpGet() {
        return this.doGet(this.targetDefault());
    }

    @Override
    public Graph httpGet(Node graphName) {
        return this.doGet(this.target(graphName));
    }

    private Graph doGet(String url) {
        HttpCaptureResponse<Graph> graph = HttpResponseLib.graphHandler();
        try {
            HttpOp.execHttpGet(url, GetAcceptHeader, graph, this.authenticator);
        }
        catch (HttpException ex) {
            if (ex.getResponseCode() == 404) {
                return null;
            }
            throw ex;
        }
        return graph.get();
    }

    @Override
    public boolean httpHead() {
        return this.doHead(this.targetDefault());
    }

    @Override
    public boolean httpHead(Node graphName) {
        return this.doHead(this.target(graphName));
    }

    private boolean doHead(String url) {
        HttpHead httpHead = new HttpHead(url);
        try {
            HttpOp.execHttpHead(url, "text/turtle,application/n-triples;q=0.9,application/rdf+xml;q=0.8,application/xml;q=0.7,*/*;q=0.5", noResponse, null, null, this.authenticator);
            return true;
        }
        catch (HttpException ex) {
            if (ex.getResponseCode() == 404) {
                return false;
            }
            throw ex;
        }
    }

    @Override
    public void httpPut(Graph data) {
        this.doPut(this.targetDefault(), data);
    }

    @Override
    public void httpPut(Node graphName, Graph data) {
        this.doPut(this.target(graphName), data);
    }

    private void doPut(String url, Graph data) {
        HttpEntity entity = DatasetGraphAccessorHTTP.graphToHttpEntity(data);
        HttpOp.execHttpPut(url, entity, null, null, this.authenticator);
    }

    @Override
    public void httpDelete() {
        this.doDelete(this.targetDefault());
    }

    @Override
    public void httpDelete(Node graphName) {
        this.doDelete(this.target(graphName));
    }

    private void doDelete(String url) {
        block2: {
            try {
                HttpOp.execHttpDelete(url, noResponse, null, null, this.authenticator);
            }
            catch (HttpException ex) {
                if (ex.getResponseCode() != 404) break block2;
                return;
            }
        }
    }

    @Override
    public void httpPost(Graph data) {
        this.doPost(this.targetDefault(), data);
    }

    @Override
    public void httpPost(Node graphName, Graph data) {
        this.doPost(this.target(graphName), data);
    }

    private void doPost(String url, Graph data) {
        HttpEntity entity = DatasetGraphAccessorHTTP.graphToHttpEntity(data);
        HttpOp.execHttpPost(url, entity, null, null, this.authenticator);
    }

    @Override
    public void httpPatch(Graph data) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void httpPatch(Node graphName, Graph data) {
        throw new UnsupportedOperationException();
    }

    private String targetDefault() {
        return this.remote + "?" + "default" + "=";
    }

    private String target(Node name) {
        if (!name.isURI()) {
            throw new JenaException("Not a URI: " + name);
        }
        String guri = name.getURI();
        guri = IRILib.encodeUriComponent(guri);
        return this.remote + "?" + "graph" + "=" + guri;
    }

    private static HttpParams createHttpParams() {
        BasicHttpParams httpParams$ = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)httpParams$, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)httpParams$, (String)"utf-8");
        HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams$, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpParams$, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)httpParams$, (int)32768);
        HttpProtocolParams.setUserAgent((HttpParams)httpParams$, (String)(Jena.NAME + "/" + Jena.VERSION));
        return httpParams$;
    }

    private static HttpEntity graphToHttpEntity(final Graph graph) {
        ContentProducer producer = new ContentProducer(){

            public void writeTo(OutputStream out) throws IOException {
                RDFDataMgr.write(out, graph, sendLang);
            }
        };
        EntityTemplate entity = new EntityTemplate(producer);
        String ct = sendLang.getLang().getContentType().getContentType();
        entity.setContentType(ct);
        return entity;
    }
}

